/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.exception;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;

@Singleton
public class MisbehavingMethods {
    private Map<String, Long> misbehavingExpiration = new ConcurrentHashMap<String, Long>();

    public boolean isMisbehaving(String misbehavingMethod) {
        Long expireTimeout = this.misbehavingExpiration.get(misbehavingMethod);
        if (expireTimeout == null) {
            return false;
        }
        if (expireTimeout > System.currentTimeMillis()) {
            return true;
        }
        this.misbehavingExpiration.remove(misbehavingMethod);
        return false;
    }

    public void markThisAsMisbehaving(String misbehavingMethod, int timeout, TimeUnit unit) {
        long expireTimeout = System.currentTimeMillis() + unit.toMillis(timeout);
        this.misbehavingExpiration.put(misbehavingMethod, expireTimeout);
    }
}

