/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css;

import com.steadystate.css.parser.CSSOMParser;
import com.ur.urcap.html.css.MutableStylePropertiesImpl;
import com.ur.urcap.html.css.StyleProperties;
import com.ur.urcap.html.css.StyleRule;
import com.ur.urcap.html.css.property.SupportedProperty;
import com.ur.util.logging.Log;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSParser {
    private CSSOMParser parser = new CSSOMParser();

    public CSSParser() {
        this.parser.setErrorHandler(new ErrorHandler(){

            public void warning(CSSParseException exception) throws CSSException {
                Log.warning((String)exception.getMessage());
            }

            public void fatalError(CSSParseException exception) throws CSSException {
                throw new CSSException((Exception)exception);
            }

            public void error(CSSParseException exception) throws CSSException {
                throw new CSSException((Exception)exception);
            }
        });
    }

    public List<StyleRule> parseStyleSheet(String css) {
        CSSStyleSheet stylesheet = this.doParseStyleSheet(css);
        if (stylesheet == null) {
            return Collections.emptyList();
        }
        ArrayList<StyleRule> result = new ArrayList<StyleRule>();
        CSSRuleList ruleList = stylesheet.getCssRules();
        int i = 0;
        while (i < ruleList.getLength()) {
            CSSRule rule = ruleList.item(i);
            if (rule instanceof CSSStyleRule) {
                CSSStyleRule cssStyleRule = (CSSStyleRule)rule;
                StyleProperties<String> properties = this.getProperties(cssStyleRule.getStyle());
                StyleRule ruleToAdd = new StyleRule(cssStyleRule.getSelectorText(), properties);
                result.add(ruleToAdd);
            }
            ++i;
        }
        return result;
    }

    public StyleRule parseInlineStyle(String css) {
        CSSStyleDeclaration declaration = this.doParseInlineStyle(css);
        if (declaration == null) {
            return null;
        }
        StyleProperties<String> properties = this.getProperties(declaration);
        return new StyleRule("", properties);
    }

    private CSSStyleSheet doParseStyleSheet(String css) {
        try {
            return this.parser.parseStyleSheet(new InputSource((Reader)new StringReader(css)), null, null);
        }
        catch (IOException ioe) {
            Log.error((String)"Could not read style sheet", (Throwable)ioe);
            return null;
        }
        catch (CSSException csse) {
            Log.error((String)"Style sheet could not be parsed", (Throwable)csse);
            return null;
        }
    }

    private CSSStyleDeclaration doParseInlineStyle(String css) {
        try {
            return this.parser.parseStyleDeclaration(new InputSource((Reader)new StringReader(css)));
        }
        catch (IOException ioe) {
            Log.error((String)"Could not read style sheet", (Throwable)ioe);
            return null;
        }
        catch (CSSException csse) {
            Log.error((String)"Style sheet could not be parsed", (Throwable)csse);
            return null;
        }
    }

    private StyleProperties<String> getProperties(CSSStyleDeclaration styleDeclaration) {
        MutableStylePropertiesImpl<String> result = new MutableStylePropertiesImpl<String>();
        int j = 0;
        while (j < styleDeclaration.getLength()) {
            String propertyName = styleDeclaration.item(j);
            String propertyValue = styleDeclaration.getPropertyCSSValue(propertyName).getCssText();
            SupportedProperty property = SupportedProperty.forName(propertyName);
            result.updateValue(property, propertyValue);
            ++j;
        }
        return result;
    }
}

