/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css;

import com.ur.lang.EqualsUtil;
import com.ur.urcap.html.css.CSSParser;
import com.ur.urcap.html.css.CSSPropertySwingStyler;
import com.ur.urcap.html.css.DefaultCss;
import com.ur.urcap.html.css.DocumentStyle;
import com.ur.urcap.html.css.MutableStyleProperties;
import com.ur.urcap.html.css.MutableStylePropertiesImpl;
import com.ur.urcap.html.css.NodeVisitorTemplate;
import com.ur.urcap.html.css.StyleProperties;
import com.ur.urcap.html.css.StyleRule;
import com.ur.urcap.html.css.property.PropertyDescriptor;
import com.ur.urcap.html.css.property.SupportedProperty;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.NodeVisitor;

public class CSSToSwingConverter {
    private final CSSParser parser;
    private final Provider<DefaultCss> defaultCss;

    @Inject
    public CSSToSwingConverter(CSSParser parser, Provider<DefaultCss> defaultCss) {
        this.parser = parser;
        this.defaultCss = defaultCss;
    }

    public DocumentStyle<CSSPropertySwingStyler> computeStyle(Document document) {
        DocumentStyle<String> declaredStyle = this.getDeclaredStyle(document);
        MutableDocumentStyleImpl computedStyle = new MutableDocumentStyleImpl();
        this.computeStyleRecursively((Node)document.body(), computedStyle, declaredStyle);
        return computedStyle.getSwingStyler();
    }

    private DocumentStyle<String> getDeclaredStyle(final Document document) {
        final MutableDocumentStyleImpl result = new MutableDocumentStyleImpl();
        this.processStyleTagContent(((DefaultCss)this.defaultCss.get()).getDefaultCss(), document, result);
        document.traverse((NodeVisitor)new NodeVisitorTemplate(){

            @Override
            public void visit(Node node, int depth) {
                if (EqualsUtil.equals((Object)node.nodeName(), (Object)"style")) {
                    for (DataNode each : ((Element)node).dataNodes()) {
                        CSSToSwingConverter.this.processStyleTagContent(each.getWholeData(), document, result);
                    }
                }
            }
        });
        document.traverse((NodeVisitor)new NodeVisitorTemplate(){

            @Override
            public void visit(Node node, int depth) {
                StyleRule rule;
                if (node.hasAttr("style") && (rule = CSSToSwingConverter.this.parser.parseInlineStyle(node.attr("style"))) != null) {
                    result.update(node, rule.getProperties());
                }
            }
        });
        return result;
    }

    private void processStyleTagContent(String css, Document document, MutableDocumentStyle result) {
        List<StyleRule> styleRules = this.parser.parseStyleSheet(css);
        for (StyleRule eachRule : styleRules) {
            String selector = eachRule.getSelector();
            for (Element affectedElement : document.select(selector)) {
                result.update((Node)affectedElement, eachRule.getProperties());
            }
        }
    }

    private void computeStyleRecursively(Node node, MutableDocumentStyle computedStyle, DocumentStyle<String> userStyle) {
        Node parent = node.parent();
        MutableStylePropertiesImpl<String> parentStyle = computedStyle.get(parent);
        if (parentStyle == null) {
            parentStyle = new MutableStylePropertiesImpl<String>();
        }
        MutableStyleProperties<String> nodeStyle = this.computeValuesFor(node, parentStyle, userStyle.get(node));
        computedStyle.put(node, nodeStyle);
        for (Node each : node.childNodes()) {
            this.computeStyleRecursively(each, computedStyle, userStyle);
        }
    }

    private MutableStyleProperties<String> computeValuesFor(Node node, StyleProperties<String> parentStyle, StyleProperties<String> userStyle) {
        MutableStylePropertiesImpl<String> result = new MutableStylePropertiesImpl<String>();
        SupportedProperty[] supportedPropertyArray = SupportedProperty.values();
        int n = supportedPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            SupportedProperty each = supportedPropertyArray[n2];
            PropertyDescriptor descriptor = each.getDescriptor();
            String derivedValue = descriptor.computeValueFor(node, parentStyle, userStyle);
            if (derivedValue != null) {
                result.updateValue(each, derivedValue);
            }
            ++n2;
        }
        return result;
    }

    private static class DocumentStyleImpl<V>
    extends HashMap<Node, MutableStyleProperties<V>>
    implements DocumentStyle<V> {
        private DocumentStyleImpl() {
        }

        @Override
        public MutableStyleProperties<V> get(Node node) {
            return (MutableStyleProperties)super.get(node);
        }

        /* synthetic */ DocumentStyleImpl(DocumentStyleImpl documentStyleImpl, DocumentStyleImpl documentStyleImpl2) {
            this();
        }
    }

    private static interface MutableDocumentStyle
    extends DocumentStyle<String> {
        @Override
        public MutableStyleProperties<String> get(Node var1);

        public MutableStyleProperties<String> put(Node var1, MutableStyleProperties<String> var2);

        public void update(Node var1, StyleProperties<String> var2);

        public DocumentStyle<CSSPropertySwingStyler> getSwingStyler();
    }

    private static class MutableDocumentStyleImpl
    extends DocumentStyleImpl<String>
    implements MutableDocumentStyle {
        private MutableDocumentStyleImpl() {
        }

        @Override
        public void update(Node node, StyleProperties<String> properties) {
            MutableStylePropertiesImpl<String> existingProperties = this.get(node);
            if (existingProperties == null) {
                existingProperties = new MutableStylePropertiesImpl<String>();
                this.put(node, existingProperties);
            }
            existingProperties.updateValues(properties);
        }

        @Override
        public DocumentStyle<CSSPropertySwingStyler> getSwingStyler() {
            DocumentStyleImpl<CSSPropertySwingStyler> result = new DocumentStyleImpl<CSSPropertySwingStyler>(null, null);
            for (Node eachNode : this.keySet()) {
                StyleProperties eachStyle = this.get(eachNode);
                MutableStylePropertiesImpl<CSSPropertySwingStyler> swingStyler = new MutableStylePropertiesImpl<CSSPropertySwingStyler>();
                for (SupportedProperty eachProperty : eachStyle) {
                    CSSPropertySwingStyler swingProperty = eachProperty.getDescriptor().getSwingStyler(eachStyle);
                    swingStyler.updateValue(eachProperty, swingProperty);
                }
                result.put(eachNode, (CSSPropertySwingStyler)((Object)swingStyler));
            }
            return result;
        }
    }
}

