/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css;

import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.urcap.html.css.CSSPropertySwingStyler;
import com.ur.urcap.html.css.DocumentStyle;
import com.ur.urcap.html.css.JComponentFactory;
import com.ur.urcap.html.css.StyleProperties;
import com.ur.urcap.html.css.SwingStyler;
import com.ur.urcap.html.css.property.DisplayDescriptor;
import com.ur.urcap.html.css.property.SupportedProperty;
import com.ur.util.Predicate;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class ElementConverter {
    private final JComponentFactory factory;
    private final DocumentStyle<CSSPropertySwingStyler> documentStyle;
    private JPanel verticalLayoutPanel;
    private JPanel horizontalLayoutPanel;
    private boolean lastFlowComponentHadNoTrailingSpace = false;
    private boolean spaceEncountered = false;

    public ElementConverter(JComponentFactory factory, DocumentStyle<CSSPropertySwingStyler> documentStyle) {
        this.factory = factory;
        this.documentStyle = documentStyle;
    }

    public JComponent convert(Element element) {
        JComponent implicitComponent = this.getImplicitJComponent(element);
        if (implicitComponent == null) {
            for (Node child : element.childNodes()) {
                if (child instanceof TextNode) {
                    this.processTextNode((TextNode)child);
                    continue;
                }
                if (!(child instanceof Element)) continue;
                this.processElement((Element)child);
            }
        } else {
            this.addComponent(implicitComponent, this.documentStyle.get((Node)element), true);
        }
        return this.determineResult(element);
    }

    public boolean hasNoTrailingSpace() {
        return this.lastFlowComponentHadNoTrailingSpace;
    }

    private JComponent getImplicitJComponent(Element element) {
        String elementName = element.nodeName();
        StyleProperties<CSSPropertySwingStyler> style = this.documentStyle.get((Node)element);
        if (EqualsUtil.equals((Object)elementName, (Object)"select")) {
            int size = 1;
            if (element.hasAttr("size")) {
                try {
                    size = Integer.parseInt(element.attr("size"));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (size == 1) {
                return this.applyStyle(this.factory.createJComboBox(), style);
            }
            return this.applyStyle(this.factory.createJList(), style);
        }
        if (EqualsUtil.equals((Object)elementName, (Object)"label")) {
            return this.applyStyle(this.factory.createJLabel(element.text()), style);
        }
        if (EqualsUtil.equals((Object)elementName, (Object)"input")) {
            String type = "text";
            if (element.hasAttr("type")) {
                type = element.attr("type");
            }
            String value = element.attr("value");
            boolean checked = element.hasAttr("checked");
            String name = element.attr("name");
            if (EqualsUtil.equals((Object)type, (Object)"text")) {
                return this.applyStyle(this.factory.createJTextField(value), style);
            }
            if (EqualsUtil.equals((Object)type, (Object)"number")) {
                return this.applyStyle(this.factory.createJTextFieldAsNumberField(value, element), style);
            }
            if (EqualsUtil.equals((Object)type, (Object)"button")) {
                return this.applyStyle(this.factory.createJButton(value), style);
            }
            if (EqualsUtil.equals((Object)type, (Object)"checkbox")) {
                return this.applyStyle(this.factory.createJCheckBox(checked), style);
            }
            if (EqualsUtil.equals((Object)type, (Object)"radio")) {
                return this.applyStyle(this.factory.createJRadioButton(checked, name), style);
            }
        }
        if (EqualsUtil.equals((Object)elementName, (Object)"img")) {
            return this.applyStyle(this.factory.createImageJLabel(), style);
        }
        if (EqualsUtil.equals((Object)elementName, (Object)"hr")) {
            return this.factory.createHorizontalSeparator();
        }
        return null;
    }

    private void processTextNode(TextNode textNode) {
        String jLabelText = textNode.text();
        if (!StringUtils.isNullOrOnlyWhitespace((String)jLabelText.trim())) {
            JLabel label = this.factory.createJLabel(jLabelText);
            this.applyStyle(label, this.documentStyle.get((Node)textNode));
            this.getHorizontalLayoutPanel().add(label);
            this.lastFlowComponentHadNoTrailingSpace = !jLabelText.endsWith(" ");
            this.spaceEncountered = false;
        } else if (jLabelText.length() > 0) {
            this.spaceEncountered = true;
        }
    }

    private void processElement(Element childElement) {
        if (EqualsUtil.equals((Object)childElement.nodeName(), (Object)"br")) {
            if (this.getHorizontalLayoutPanel().getComponentCount() == 0) {
                this.getHorizontalLayoutPanel().add(this.factory.createJLabel(""));
            }
            this.finalizeFlowLayoutPanel(true);
        } else {
            if (EqualsUtil.equals((Object)childElement.nodeName(), (Object)"option")) {
                return;
            }
            ElementConverter converter = new ElementConverter(this.factory, this.documentStyle);
            JComponent childComponent = converter.convert(childElement);
            StyleProperties<CSSPropertySwingStyler> styleProperties = this.documentStyle.get((Node)childElement);
            this.addComponent(childComponent, styleProperties, converter.hasNoTrailingSpace());
        }
    }

    private void addComponent(JComponent childComponent, StyleProperties<CSSPropertySwingStyler> styleProperties, boolean hasNoTrailingSpace) {
        if (childComponent != null) {
            CSSPropertySwingStyler value = styleProperties.getValue(SupportedProperty.DISPLAY);
            switch ((DisplayDescriptor.Value)value) {
                case BLOCK: {
                    this.finalizeFlowLayoutPanel(true);
                    this.getVerticalLayoutPanel().add(childComponent);
                    break;
                }
                case INLINE_BLOCK: 
                case INLINE: {
                    if (this.spaceEncountered && this.lastFlowComponentHadNoTrailingSpace) {
                        this.getHorizontalLayoutPanel().add(this.applyStyle(this.factory.createJLabel(" "), styleProperties.removeMatching(new Predicate<SupportedProperty>(){

                            public boolean test(SupportedProperty t) {
                                return EqualsUtil.equalsOneOf((Object)((Object)t), (Object[])new SupportedProperty[]{SupportedProperty.WIDTH, SupportedProperty.HEIGHT, SupportedProperty.DISPLAY});
                            }
                        })));
                    }
                    if (childComponent instanceof JPanel && childComponent.getComponentCount() == 1) {
                        childComponent = (JComponent)childComponent.getComponent(0);
                    }
                    this.getHorizontalLayoutPanel().add(childComponent);
                    this.lastFlowComponentHadNoTrailingSpace = hasNoTrailingSpace;
                    this.spaceEncountered = false;
                    break;
                }
            }
        }
    }

    private JComponent determineResult(Element element) {
        this.finalizeFlowLayoutPanel(false);
        if (this.verticalLayoutPanel != null) {
            int childCount = this.verticalLayoutPanel.getComponentCount();
            if (childCount > 1) {
                this.applyStyle(this.verticalLayoutPanel, this.documentStyle.get((Node)element));
                this.nameComponent(element, this.verticalLayoutPanel);
                return this.verticalLayoutPanel;
            }
            if (childCount == 1) {
                JComponent result = (JComponent)this.verticalLayoutPanel.getComponent(0);
                this.applyStyle(result, this.documentStyle.get((Node)element));
                if (result.getComponentCount() == 1 && result.getComponent(0).getName() == null) {
                    this.nameComponent(element, result.getComponent(0));
                } else {
                    this.nameComponent(element, result);
                }
                return result;
            }
        }
        return null;
    }

    private void nameComponent(Element element, Component component) {
        if (element.hasAttr("id")) {
            if (component instanceof JScrollPane) {
                component = ((JScrollPane)component).getViewport().getView();
            }
            component.setName(element.attr("id"));
        }
    }

    private JPanel getVerticalLayoutPanel() {
        if (this.verticalLayoutPanel == null) {
            this.verticalLayoutPanel = this.factory.createVerticalLayoutJPanel();
        }
        return this.verticalLayoutPanel;
    }

    private JPanel getHorizontalLayoutPanel() {
        if (this.horizontalLayoutPanel == null) {
            this.horizontalLayoutPanel = this.factory.createHorizontalLayoutJPanel();
        }
        return this.horizontalLayoutPanel;
    }

    private void finalizeFlowLayoutPanel(boolean resetFlags) {
        int childCount;
        if (this.horizontalLayoutPanel != null && (childCount = this.horizontalLayoutPanel.getComponentCount()) > 0) {
            this.getVerticalLayoutPanel().add(this.horizontalLayoutPanel);
            this.horizontalLayoutPanel = null;
        }
        if (resetFlags) {
            this.lastFlowComponentHadNoTrailingSpace = false;
            this.spaceEncountered = false;
        }
    }

    private <T extends JComponent> T applyStyle(T component, StyleProperties<? extends SwingStyler> style) {
        component.setAlignmentX(0.0f);
        component.setAlignmentY(0.0f);
        for (SupportedProperty each : style) {
            style.getValue(each).applyTo(component);
        }
        return component;
    }
}

