/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css;

import com.ur.urcap.html.css.NodeVisitorTemplate;
import com.ur.urcap.html.css.UnsupportedNodeException;
import com.ur.urcap.html.filter.NodeFilter;
import com.ur.util.logging.Log;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.select.NodeVisitor;

public class HtmlParser {
    private NodeFilter filter;

    public void setAcceptedNodesFilter(NodeFilter filter) {
        this.filter = filter;
    }

    public Document parseAndValidate(String html) throws UnsupportedNodeException {
        Document document = Jsoup.parse((String)html);
        if (this.filter != null) {
            this.filter.forDocument(document);
            document.traverse((NodeVisitor)new ThrowWhenNodeNotAccepted());
            if (Log.canLog((Log.Level)Log.Level.DEBUG)) {
                document.traverse(new NodeVisitor(){

                    public void head(Node node, int depth) {
                        Log.trace((String)("begin " + node.nodeName() + " " + node.attributes().asList().toString() + " (" + depth + ")"));
                    }

                    public void tail(Node node, int depth) {
                        Log.trace((String)("end " + node.nodeName() + " (" + depth + ")"));
                    }
                });
            }
        }
        return document;
    }

    private class ThrowWhenNodeNotAccepted
    extends NodeVisitorTemplate {
        private ThrowWhenNodeNotAccepted() {
        }

        @Override
        public void visit(Node node, int depth) {
            if (!HtmlParser.this.filter.accept(node)) {
                throw new UnsupportedNodeException(node);
            }
        }
    }
}

