/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css;

import com.ur.urcap.contribution.UIConverter;
import com.ur.urcap.html.css.CSSPropertySwingStyler;
import com.ur.urcap.html.css.CSSToSwingConverter;
import com.ur.urcap.html.css.DocumentStyle;
import com.ur.urcap.html.css.ElementConverter;
import com.ur.urcap.html.css.HtmlParser;
import com.ur.urcap.html.css.JComponentFactory;
import com.ur.urcap.html.css.SupportedElement;
import com.ur.urcap.html.css.UnsupportedNodeException;
import com.ur.util.logging.Log;
import javax.inject.Inject;
import javax.swing.JComponent;
import org.jsoup.nodes.Document;

public class HtmlToSwingConverter
implements UIConverter {
    private final HtmlParser parser;
    private final JComponentFactory factory;
    private final CSSToSwingConverter styler;

    @Inject
    public HtmlToSwingConverter(HtmlParser parser, JComponentFactory factory, CSSToSwingConverter styler) {
        this.parser = parser;
        this.factory = factory;
        this.styler = styler;
        parser.setAcceptedNodesFilter(SupportedElement.createAcceptedNodesFilter());
    }

    @Override
    public JComponent convert(String html) {
        Document document;
        try {
            document = this.parser.parseAndValidate(html);
        }
        catch (UnsupportedNodeException une) {
            Log.error((String)"Could not parse HTML source", (Throwable)une);
            return null;
        }
        DocumentStyle<CSSPropertySwingStyler> style = this.styler.computeStyle(document);
        return new ElementConverter(this.factory, style).convert(document.body());
    }
}

