/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css;

import com.ur.i18n.TextResource;
import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.swing.CompletedListener;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberFieldBorderable;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.contribution.PanelCreator;
import com.ur.urcap.html.css.VerticalLayout;
import gui.tools.LanguagePack;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultFormatter;
import org.jsoup.nodes.Element;

public class JComponentFactory
implements PanelCreator {
    public static final Dimension NO_CSS_APPLIED = new Dimension(0, 0);
    private final Map<String, ButtonGroup> radioButtonGroups = new HashMap<String, ButtonGroup>();
    private TextResource textResource = LanguagePack.getTextResource();

    public JPanel createVerticalLayoutJPanel() {
        JPanel result = new JPanel();
        result.setLayout(new VerticalLayout(0, 2, 1));
        return result;
    }

    public JPanel createHorizontalLayoutJPanel() {
        JPanel result = new JPanel();
        result.setLayout(new FlowLayout(0, 0, 0));
        result.setAlignmentX(0.0f);
        return result;
    }

    public JLabel createJLabel(String content) {
        return new JLabel(content);
    }

    public JLabel createImageJLabel() {
        return this.createJLabel("");
    }

    public JComboBox createJComboBox() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setPreferredSize(NO_CSS_APPLIED);
        return jComboBox;
    }

    public JComponent createJList() {
        JList jList = new JList(new DefaultListModel());
        return new JScrollPane(jList);
    }

    public JTextField createJTextField(String value) {
        final JFormattedTextField textField = this.createTextField();
        textField.setValue(value);
        TextFieldUtils.bindTextPicker((JComponent)textField, (TextHolder)new TextHolder(){

            public String getText() {
                return textField.getText();
            }

            public void setText(String text) {
                textField.setValue(text);
            }
        }, (CompletedListener)this.getTransferFocusListener(textField), (ValidationStrategy)ValidationStrategy.ALWAYS_VALID);
        return textField;
    }

    private CompletedListener getTransferFocusListener(final JFormattedTextField textField) {
        return new CompletedListener(){

            public void requestApply() {
                textField.transferFocus();
                textField.postActionEvent();
            }

            public void requestCancel() {
            }
        };
    }

    public JComponent createJTextFieldAsNumberField(String value, Element element) {
        NumberFieldBorderable numberField = new NumberFieldBorderable();
        numberField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"##.###"));
        numberField.setUnitWidth(0);
        numberField.setText(value);
        boolean useWholeNumbers = false;
        boolean usePositiveNumbers = false;
        ValidationStrategy rangeValidator = null;
        ValidationStrategy wholeNumberValidator = null;
        if (element.hasAttr("step") && PrimitiveUtils.parseInteger((String)element.attr("step"), (int)0) == 1) {
            useWholeNumbers = true;
            wholeNumberValidator = ValidationFactory.getWholeNumberValidator();
        }
        if (element.hasAttr("min") || element.hasAttr("max")) {
            double minimum = PrimitiveUtils.parseDouble((String)element.attr("min"), (double)-2.147483648E9);
            double maximum = PrimitiveUtils.parseDouble((String)element.attr("max"), (double)2.147483647E9);
            String valueOutOfRange = this.textResource.valueOutOfRange(minimum, "", maximum);
            rangeValidator = ValidationFactory.getRangeValidator((double)minimum, (double)maximum, (String)valueOutOfRange);
            if (minimum >= 0.0) {
                usePositiveNumbers = true;
            }
        }
        Mode mode = useWholeNumbers ? (usePositiveNumbers ? Mode.PositiveWholeNumbers : Mode.WholeNumbers) : (usePositiveNumbers ? Mode.PositiveNumbers : Mode.Standard);
        numberField.setMode(mode);
        if (rangeValidator != null && wholeNumberValidator != null) {
            numberField.setErrorValidationStrategy(new ValidationStrategy[]{new ValidationStrategy.Composite(new ValidationStrategy[]{rangeValidator, wholeNumberValidator})});
        } else if (rangeValidator != null) {
            numberField.setErrorValidationStrategy(new ValidationStrategy[]{rangeValidator});
        } else if (wholeNumberValidator != null) {
            numberField.setErrorValidationStrategy(new ValidationStrategy[]{wholeNumberValidator});
        } else {
            numberField.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getNumberValidator()});
        }
        return numberField;
    }

    private JFormattedTextField createTextField() {
        DefaultFormatter formatter = new DefaultFormatter();
        formatter.setCommitsOnValidEdit(true);
        return new JFormattedTextField(formatter);
    }

    public JCheckBox createJCheckBox(boolean checked) {
        JCheckBox result = new JCheckBox();
        result.setSelected(checked);
        return result;
    }

    public JButton createJButton(String value) {
        return new JButton(value);
    }

    public JRadioButton createJRadioButton(boolean checked, String groupName) {
        JRadioButton result = new JRadioButton();
        result.setSelected(checked);
        ButtonGroup group = this.radioButtonGroups.get(groupName);
        if (group == null) {
            group = new ButtonGroup();
            this.radioButtonGroups.put(groupName, group);
        }
        group.add(result);
        return result;
    }

    public JSeparator createHorizontalSeparator() {
        return new JSeparator(0);
    }

    public JPanel createJPanel(final Dimension size) {
        JPanel jPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(size);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(size);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(size);
            }

            @Override
            public Dimension getSize() {
                return new Dimension(size);
            }

            @Override
            public int getWidth() {
                return new Dimension((Dimension)size).width;
            }

            @Override
            public int getHeight() {
                return new Dimension((Dimension)size).height;
            }
        };
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        return jPanel;
    }

    @Override
    public JPanel createTitledPanel(JPanel titleComponent, JPanel panel) {
        JPanel viewComponent = new JPanel();
        viewComponent.setLayout(new BorderLayout());
        viewComponent.setBorder(BorderFactory.createEmptyBorder());
        viewComponent.add((Component)titleComponent, "First");
        viewComponent.add((Component)panel, "Before");
        return viewComponent;
    }

    @Override
    public JPanel createTitlePanelWithLogo(String title, Color titleBackgroundColor, Font titleFont, Border titleBorder, Icon icon) {
        JPanel titlePanel = this.createVerticalLayoutJPanel();
        titlePanel.setBackground(titleBackgroundColor);
        titlePanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel label = new JLabel(title);
        label.setFont(titleFont);
        label.setBorder(titleBorder);
        label.setHorizontalAlignment(2);
        titlePanel.add(label);
        JPanel imagePanel = new JPanel();
        imagePanel.setLayout(new FlowLayout(2, 0, 0));
        imagePanel.setAlignmentX(1.0f);
        JLabel image = new JLabel();
        image.setIcon(icon);
        imagePanel.setBorder(new EmptyBorder(5, 0, 0, 15));
        imagePanel.add(image);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.gridy = 0;
        c.gridx = 0;
        panel.add((Component)label, c);
        c.gridy = 0;
        c.gridx = 1;
        panel.add((Component)imagePanel, c);
        return panel;
    }

    @Override
    public JPanel createTitlePanel(String title, Color titleBackGroundColor, Font titleFont, Border titleBorder) {
        JPanel titlePanel = this.createVerticalLayoutJPanel();
        titlePanel.setBackground(titleBackGroundColor);
        titlePanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel label = new JLabel(title);
        label.setFont(titleFont);
        label.setBorder(titleBorder);
        titlePanel.add(label);
        return titlePanel;
    }
}

