/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css;

import com.ur.urcap.html.css.UnsupportedNodeException;
import com.ur.urcap.html.filter.BasicHtmlNodesFilter;
import com.ur.urcap.html.filter.CSSSelectorNodeFilter;
import com.ur.urcap.html.filter.NodeFilter;
import com.ur.urcap.html.filter.OrNodeFilter;
import java.util.HashMap;
import java.util.Map;

public enum SupportedElement {
    BODY("body"),
    FORM("form"),
    DIV("div"),
    LABEL("label"),
    SELECT("select"),
    INPUT("input"),
    OPTION("option"),
    P("p"),
    H1("h1"),
    H2("h2"),
    H3("h3"),
    IMG("img"),
    SPAN("span"),
    EM("em"),
    I("i"),
    B("b"),
    BR("br"),
    HR("hr");

    private static Map<String, SupportedElement> elementNameCache;
    private String elementName;

    static {
        elementNameCache = new HashMap<String, SupportedElement>();
    }

    private SupportedElement(String elementName) {
        this.elementName = elementName;
    }

    public static SupportedElement forName(String elementName) {
        if (elementNameCache.isEmpty()) {
            SupportedElement.buildCache();
        }
        if (elementNameCache.containsKey(elementName)) {
            return elementNameCache.get(elementName);
        }
        throw new UnsupportedNodeException(elementName);
    }

    private static void buildCache() {
        SupportedElement[] supportedElementArray = SupportedElement.values();
        int n = supportedElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            SupportedElement each = supportedElementArray[n2];
            elementNameCache.put(each.getElementName(), each);
            ++n2;
        }
    }

    public static NodeFilter createAcceptedNodesFilter() {
        OrNodeFilter result = new OrNodeFilter(new BasicHtmlNodesFilter(), new CSSSelectorNodeFilter("head > title"), new CSSSelectorNodeFilter("style"), new CSSSelectorNodeFilter("body > form"), new CSSSelectorNodeFilter("body > div"), new CSSSelectorNodeFilter("form > div"), new CSSSelectorNodeFilter("div > div"), new CSSSelectorNodeFilter("form > label"), new CSSSelectorNodeFilter("form > select"), new CSSSelectorNodeFilter("form > input"), new CSSSelectorNodeFilter("form div > label"), new CSSSelectorNodeFilter("form div > select"), new CSSSelectorNodeFilter("form div > input"), new CSSSelectorNodeFilter("form p > label"), new CSSSelectorNodeFilter("form p > select"), new CSSSelectorNodeFilter("form p > input"), new CSSSelectorNodeFilter("select > option"), new CSSSelectorNodeFilter("body > h1"), new CSSSelectorNodeFilter("body > h2"), new CSSSelectorNodeFilter("body > h3"), new CSSSelectorNodeFilter("body > p"), new CSSSelectorNodeFilter("body > img"), new CSSSelectorNodeFilter("form > h1"), new CSSSelectorNodeFilter("form > h2"), new CSSSelectorNodeFilter("form > h3"), new CSSSelectorNodeFilter("form > p"), new CSSSelectorNodeFilter("div > h1"), new CSSSelectorNodeFilter("div > h2"), new CSSSelectorNodeFilter("div > h3"), new CSSSelectorNodeFilter("div > p"), new CSSSelectorNodeFilter("div > img"), new CSSSelectorNodeFilter("span"), new CSSSelectorNodeFilter("em"), new CSSSelectorNodeFilter("b"), new CSSSelectorNodeFilter("i"), new CSSSelectorNodeFilter("br"), new CSSSelectorNodeFilter("hr"));
        return result;
    }

    public String getElementName() {
        return this.elementName;
    }
}

