/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalLayout
implements LayoutManager {
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int BOTH = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    private final int vgap;
    private final int alignment;
    private final int anchor;

    public VerticalLayout() {
        this(5, 0, 1);
    }

    public VerticalLayout(int vgap) {
        this(vgap, 0, 1);
    }

    public VerticalLayout(int vgap, int alignment) {
        this(vgap, alignment, 1);
    }

    public VerticalLayout(int vgap, int alignment, int anchor) {
        this.vgap = vgap;
        this.alignment = alignment;
        this.anchor = anchor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container parent, boolean minimum) {
        Dimension dim = new Dimension(0, 0);
        Object object = parent.getTreeLock();
        synchronized (object) {
            int n = parent.getComponentCount();
            int i = 0;
            while (i < n) {
                Component c = parent.getComponent(i);
                if (c.isVisible()) {
                    Dimension d = minimum ? c.getMinimumSize() : c.getPreferredSize();
                    dim.width = Math.max(dim.width, d.width);
                    dim.height += d.height;
                    if (i > 0) {
                        dim.height += this.vgap;
                    }
                }
                ++i;
            }
        }
        Insets insets = parent.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom + this.vgap + this.vgap;
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension d;
            Component c;
            int n = parent.getComponentCount();
            Dimension pd = parent.getSize();
            int y = 0;
            int i = 0;
            while (i < n) {
                c = parent.getComponent(i);
                d = c.getPreferredSize();
                y += d.height + this.vgap;
                ++i;
            }
            y -= this.vgap;
            y = this.anchor == 1 ? insets.top : (this.anchor == 0 ? (pd.height - y) / 2 : pd.height - y - insets.bottom);
            i = 0;
            while (i < n) {
                c = parent.getComponent(i);
                d = c.getPreferredSize();
                int x = insets.left;
                int wid = d.width;
                if (this.alignment == 0) {
                    x = (pd.width - d.width) / 2;
                } else if (this.alignment == 1) {
                    x = pd.width - d.width - insets.right;
                } else if (this.alignment == 3) {
                    wid = pd.width - insets.left - insets.right;
                }
                c.setBounds(x, y, wid, d.height);
                y += d.height + this.vgap;
                ++i;
            }
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutSize(parent, false);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutSize(parent, false);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[vgap=" + this.vgap + " align=" + this.alignment + " anchor=" + this.anchor + "]";
    }
}

