/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css.internal;

import com.ur.bean.InvokeField;
import com.ur.urcap.api.ui.annotation.Div;
import com.ur.urcap.api.ui.annotation.Img;
import com.ur.urcap.api.ui.annotation.Input;
import com.ur.urcap.api.ui.annotation.Label;
import com.ur.urcap.api.ui.annotation.Select;
import com.ur.urcap.api.ui.component.HTMLComponent;
import com.ur.util.logging.Log;
import java.lang.annotation.Annotation;

public class FieldBinder {
    private static final Class<?>[] SUPPORTED_HTML_ANNOTATIONS = new Class[]{Div.class, Img.class, Input.class, Label.class, Select.class};
    private HTMLComponent component;
    private InvokeField field;

    public FieldBinder(HTMLComponent component, InvokeField field) {
        this.component = component;
        this.field = field;
    }

    public void populate() {
        if (this.field == null || this.component == null) {
            return;
        }
        if (this.field.getFieldType().isAssignableFrom(this.component.getClass())) {
            this.field.set((Object)this.component);
        } else {
            String htmlId = FieldBinder.getIdAnnotation(this.field);
            if (htmlId != null) {
                Log.error((String)String.format("Mismatch between HTML type with id=%s and java type for variable=%s ", htmlId, this.field.getName()));
            } else {
                Log.error((String)("Failed to bind HTML with java field " + this.field.getName()));
            }
        }
    }

    public static String getIdAnnotation(InvokeField field) {
        Class<?>[] classArray = SUPPORTED_HTML_ANNOTATIONS;
        int n = SUPPORTED_HTML_ANNOTATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            int endIndex;
            String annotation;
            int i;
            Class<?> annotationClass = classArray[n2];
            Annotation annotationObject = field.getAnnotation(annotationClass);
            if (annotationObject != null && (i = (annotation = ((Object)annotationObject).toString()).indexOf("(id=")) >= 0 && (endIndex = annotation.indexOf(")", i)) >= 0) {
                return annotation.substring(i + 4, endIndex);
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return "FieldBinder: " + this.field.toString();
    }
}

