/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css.property;

import com.ur.urcap.html.css.CSSPropertySwingStyler;
import com.ur.urcap.html.css.StyleProperties;
import com.ur.urcap.html.css.property.PropertyDescriptor;
import com.ur.urcap.html.css.property.SupportedProperty;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public class DisplayDescriptor
implements PropertyDescriptor {
    @Override
    public String getPropertyName() {
        return "display";
    }

    @Override
    public String computeValueFor(Node node, StyleProperties<String> computedParentStyle, StyleProperties<String> declaredStyle) {
        if (node instanceof Element || node instanceof TextNode) {
            String propertyValue = null;
            if (declaredStyle != null) {
                propertyValue = declaredStyle.getValue(SupportedProperty.DISPLAY);
            }
            if (propertyValue == null) {
                return Value.INLINE.getCSSValue();
            }
            return propertyValue;
        }
        return null;
    }

    @Override
    public CSSPropertySwingStyler getSwingStyler(StyleProperties<String> computedStyle) {
        return Value.forCssValue(computedStyle.getValue(SupportedProperty.DISPLAY));
    }

    public static enum Value implements CSSPropertySwingStyler
    {
        BLOCK("block"),
        INLINE_BLOCK("inline-block"),
        INLINE("inline");

        private final String cssValue;
        private static Map<String, Value> cache;

        static {
            cache = new HashMap<String, Value>();
        }

        private Value(String cssValue) {
            this.cssValue = cssValue;
        }

        @Override
        public String getCSSValue() {
            return this.cssValue;
        }

        @Override
        public void applyTo(JComponent component) {
        }

        public static Value forCssValue(String cssValue) {
            if (cache.isEmpty()) {
                Value.buildCache();
            }
            if (cache.containsKey(cssValue)) {
                return cache.get(cssValue);
            }
            throw new IllegalArgumentException("Display type \"" + cssValue + "\" is not supported.");
        }

        private static void buildCache() {
            Value[] valueArray = Value.values();
            int n = valueArray.length;
            int n2 = 0;
            while (n2 < n) {
                Value each = valueArray[n2];
                cache.put(each.getCSSValue(), each);
                ++n2;
            }
        }
    }
}

