/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css.property;

import com.ur.urcap.html.css.CSSPropertySwingStyler;
import com.ur.urcap.html.css.StyleProperties;
import com.ur.urcap.html.css.property.PropertyDescriptor;
import com.ur.urcap.html.css.property.SizeUtils;
import com.ur.urcap.html.css.property.SupportedProperty;
import javax.swing.JComponent;
import org.jsoup.nodes.Node;

class FontSizeDescriptor
implements PropertyDescriptor {
    private static final int DEFAULT_FONT_SIZE = 12;

    FontSizeDescriptor() {
    }

    @Override
    public String getPropertyName() {
        return "font-size";
    }

    @Override
    public String computeValueFor(Node node, StyleProperties<String> computedParentStyle, StyleProperties<String> declaredStyle) {
        String userValue;
        String parentValue = computedParentStyle.getValue(SupportedProperty.FONT_SIZE);
        int parentSizeInPixels = 12;
        if (parentValue != null) {
            parentSizeInPixels = SizeUtils.getSize(parentValue);
        }
        String result = null;
        if (declaredStyle != null && (userValue = declaredStyle.getValue(SupportedProperty.FONT_SIZE)) != null) {
            result = String.valueOf(Integer.toString(SizeUtils.getSize(userValue, parentSizeInPixels))) + "px";
        }
        if (result == null) {
            result = String.valueOf(Integer.toString(parentSizeInPixels)) + "px";
        }
        return result;
    }

    @Override
    public CSSPropertySwingStyler getSwingStyler(StyleProperties<String> computedStyle) {
        return new FontSizeValue(computedStyle.getValue(SupportedProperty.FONT_SIZE));
    }

    private final class FontSizeValue
    implements CSSPropertySwingStyler {
        private final int size;

        private FontSizeValue(String cssValue) {
            this.size = SizeUtils.getSize(cssValue);
        }

        @Override
        public void applyTo(JComponent component) {
            component.setFont(component.getFont().deriveFont((float)this.size));
        }

        @Override
        public String getCSSValue() {
            return String.valueOf(Integer.toString(this.size)) + "px";
        }
    }
}

