/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css.property;

import com.ur.urcap.html.css.CSSPropertySwingStyler;
import com.ur.urcap.html.css.StyleProperties;
import com.ur.urcap.html.css.property.PropertyDescriptor;
import com.ur.urcap.html.css.property.SizeUtils;
import com.ur.urcap.html.css.property.SupportedProperty;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.jsoup.nodes.Node;

class HeightDescriptor
implements PropertyDescriptor {
    HeightDescriptor() {
    }

    @Override
    public String getPropertyName() {
        return "height";
    }

    @Override
    public String computeValueFor(Node node, StyleProperties<String> computedParentStyle, StyleProperties<String> declaredStyle) {
        int size;
        String userValue;
        String parentValue = computedParentStyle.getValue(SupportedProperty.HEIGHT);
        int parentSize = -1;
        if (parentValue != null) {
            parentSize = SizeUtils.getSize(parentValue);
        }
        String result = null;
        if (declaredStyle != null && (userValue = declaredStyle.getValue(SupportedProperty.HEIGHT)) != null && (size = SizeUtils.getSize(userValue, parentSize)) >= 0) {
            result = String.valueOf(Integer.toString(size)) + "px";
        }
        return result;
    }

    @Override
    public CSSPropertySwingStyler getSwingStyler(StyleProperties<String> computedStyle) {
        return new HeightValue(computedStyle.getValue(SupportedProperty.HEIGHT));
    }

    private final class HeightValue
    implements CSSPropertySwingStyler {
        private final int size;

        private HeightValue(String cssValue) {
            this.size = SizeUtils.getSize(cssValue);
        }

        @Override
        public void applyTo(JComponent component) {
            Dimension preferredSize = component.getPreferredSize();
            Dimension newPreferredSize = new Dimension(preferredSize.width, this.size);
            component.setPreferredSize(newPreferredSize);
        }

        @Override
        public String getCSSValue() {
            return Integer.toString(this.size);
        }
    }
}

