/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css.property;

import com.ur.swing.UnitLabelBorder;
import com.ur.urcap.html.css.CSSPropertySwingStyler;
import com.ur.urcap.html.css.StyleProperties;
import com.ur.urcap.html.css.property.PropertyDescriptor;
import com.ur.urcap.html.css.property.SizeUtils;
import com.ur.urcap.html.css.property.SupportedProperty;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jsoup.nodes.Node;

public class PaddingDescriptor
implements PropertyDescriptor {
    private final String propertyName;

    public PaddingDescriptor(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String computeValueFor(Node node, StyleProperties<String> parentStyle, StyleProperties<String> userStyle) {
        String result = null;
        if (userStyle != null) {
            result = userStyle.getValue(SupportedProperty.forName(this.propertyName));
        }
        return result;
    }

    @Override
    public CSSPropertySwingStyler getSwingStyler(StyleProperties<String> computedStyle) {
        int top = -1;
        int right = -1;
        int bottom = -1;
        int left = -1;
        SupportedProperty property = SupportedProperty.forName(this.propertyName);
        String value = computedStyle.getValue(property);
        if (property == SupportedProperty.PADDING) {
            String[] values = value.trim().split("\\s+");
            if (values.length == 1) {
                int padding;
                top = padding = SizeUtils.getSize(values[0]);
                right = padding;
                bottom = padding;
                left = padding;
            }
            if (values.length == 2) {
                int verticalPadding = SizeUtils.getSize(values[0]);
                int horizontalPadding = SizeUtils.getSize(values[1]);
                top = verticalPadding;
                right = horizontalPadding;
                bottom = verticalPadding;
                left = horizontalPadding;
            } else if (values.length == 4) {
                top = SizeUtils.getSize(values[0]);
                right = SizeUtils.getSize(values[1]);
                bottom = SizeUtils.getSize(values[2]);
                left = SizeUtils.getSize(values[3]);
            }
        } else if (property == SupportedProperty.PADDING_TOP) {
            top = SizeUtils.getSize(value);
        } else if (property == SupportedProperty.PADDING_RIGHT) {
            right = SizeUtils.getSize(value);
        } else if (property == SupportedProperty.PADDING_BOTTOM) {
            bottom = SizeUtils.getSize(value);
        } else if (property == SupportedProperty.PADDING_LEFT) {
            left = SizeUtils.getSize(value);
        }
        return new PaddingStyler(top, left, bottom, right, value);
    }

    private static class PaddingStyler
    implements CSSPropertySwingStyler {
        private final int topPadding;
        private final int leftPadding;
        private final int bottomPadding;
        private final int rightPadding;
        private final String cssValue;

        public PaddingStyler(int topPadding, int leftPadding, int bottomPadding, int rightPadding, String cssValue) {
            this.topPadding = topPadding;
            this.leftPadding = leftPadding;
            this.bottomPadding = bottomPadding;
            this.rightPadding = rightPadding;
            this.cssValue = cssValue;
        }

        @Override
        public void applyTo(JComponent component) {
            CompoundBorder compoundBorder;
            Border outsideBorder;
            Border outsideBorder2;
            Border originalBorder = component.getBorder();
            Insets borderInsets = new Insets(0, 0, 0, 0);
            if (originalBorder instanceof EmptyBorder) {
                borderInsets = ((EmptyBorder)originalBorder).getBorderInsets();
            } else if (originalBorder instanceof CompoundBorder && (outsideBorder2 = ((CompoundBorder)originalBorder).getOutsideBorder()) instanceof EmptyBorder) {
                borderInsets = ((EmptyBorder)outsideBorder2).getBorderInsets();
            }
            int top = this.topPadding >= 0 ? this.topPadding : borderInsets.top;
            int left = this.leftPadding >= 0 ? this.leftPadding : borderInsets.left;
            int bottom = this.bottomPadding >= 0 ? this.bottomPadding : borderInsets.bottom;
            int right = this.rightPadding >= 0 ? this.rightPadding : borderInsets.right;
            borderInsets.set(top, left, bottom, right);
            EmptyBorder newOutsideBorder = new EmptyBorder(borderInsets);
            boolean borderSet = false;
            if (originalBorder == null || originalBorder instanceof EmptyBorder) {
                component.setBorder(newOutsideBorder);
                borderSet = true;
            } else if (originalBorder instanceof CompoundBorder && (outsideBorder = (compoundBorder = (CompoundBorder)originalBorder).getOutsideBorder()) instanceof EmptyBorder && !(outsideBorder instanceof UnitLabelBorder)) {
                component.setBorder(new CompoundBorder(newOutsideBorder, compoundBorder.getInsideBorder()));
                borderSet = true;
            }
            if (!borderSet) {
                component.setBorder(new CompoundBorder(newOutsideBorder, originalBorder));
            }
        }

        @Override
        public String getCSSValue() {
            return this.cssValue;
        }
    }
}

