/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css.property;

class SizeUtils {
    SizeUtils() {
    }

    public static int getSize(String size) {
        int result = SizeUtils.parseSize(size.trim());
        if (result == -1) {
            throw new IllegalArgumentException("Unrecognized size string \"" + size + "\"");
        }
        return result;
    }

    public static int getSize(String size, int parentSize) {
        int result = SizeUtils.parseSize(size.trim());
        if (result == -1 && size.matches("^[0-9]+%$")) {
            if (parentSize == -1) {
                return -1;
            }
            int percent = Integer.parseInt(size.substring(0, size.length() - 1));
            return (int)((double)parentSize * (0.01 * (double)percent));
        }
        if (result == -1) {
            throw new IllegalArgumentException("Unrecognized size string \"" + size + "\"");
        }
        return result;
    }

    private static int parseSize(String size) {
        if (size.matches("^[0-9]+$")) {
            return Integer.parseInt(size);
        }
        if (size.matches("^[0-9]+px$")) {
            return Integer.parseInt(size.substring(0, size.length() - 2));
        }
        return -1;
    }
}

