/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css.property;

import com.ur.urcap.html.css.UnsupportedPropertyException;
import com.ur.urcap.html.css.property.DisplayDescriptor;
import com.ur.urcap.html.css.property.FontSizeDescriptor;
import com.ur.urcap.html.css.property.FontStyleDescriptor;
import com.ur.urcap.html.css.property.FontWeightDescriptor;
import com.ur.urcap.html.css.property.HeightDescriptor;
import com.ur.urcap.html.css.property.PaddingDescriptor;
import com.ur.urcap.html.css.property.PropertyDescriptor;
import com.ur.urcap.html.css.property.TextAlignDescriptor;
import com.ur.urcap.html.css.property.VerticalAlignDescriptor;
import com.ur.urcap.html.css.property.WidthDescriptor;
import java.util.HashMap;
import java.util.Map;

public enum SupportedProperty {
    TEXT_ALIGN(new TextAlignDescriptor()),
    VERTICAL_ALIGN(new VerticalAlignDescriptor()),
    DISPLAY(new DisplayDescriptor()),
    WIDTH(new WidthDescriptor()),
    HEIGHT(new HeightDescriptor()),
    FONT_WEIGHT(new FontWeightDescriptor()),
    FONT_STYLE(new FontStyleDescriptor()),
    FONT_SIZE(new FontSizeDescriptor()),
    PADDING_TOP(new PaddingDescriptor("padding-top")),
    PADDING_RIGHT(new PaddingDescriptor("padding-right")),
    PADDING_BOTTOM(new PaddingDescriptor("padding-bottom")),
    PADDING_LEFT(new PaddingDescriptor("padding-left")),
    PADDING(new PaddingDescriptor("padding"));

    private static Map<String, SupportedProperty> propertyNameCache;
    private final PropertyDescriptor descriptor;

    static {
        propertyNameCache = new HashMap<String, SupportedProperty>();
    }

    private SupportedProperty(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getName() {
        return this.descriptor.getPropertyName();
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public static SupportedProperty forName(String propertyName) {
        if (propertyNameCache.isEmpty()) {
            SupportedProperty.buildCache();
        }
        if (propertyNameCache.containsKey(propertyName)) {
            return propertyNameCache.get(propertyName);
        }
        throw new UnsupportedPropertyException(propertyName);
    }

    private static void buildCache() {
        SupportedProperty[] supportedPropertyArray = SupportedProperty.values();
        int n = supportedPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            SupportedProperty each = supportedPropertyArray[n2];
            propertyNameCache.put(each.getName(), each);
            ++n2;
        }
    }
}

