/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css.property;

import com.ur.urcap.html.css.CSSPropertySwingStyler;
import com.ur.urcap.html.css.StyleProperties;
import com.ur.urcap.html.css.property.PropertyDescriptor;
import com.ur.urcap.html.css.property.SupportedProperty;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class TextAlignDescriptor
implements PropertyDescriptor {
    @Override
    public String getPropertyName() {
        return "text-align";
    }

    @Override
    public String computeValueFor(Node node, StyleProperties<String> computedParentStyle, StyleProperties<String> declaredStyle) {
        String propertyValue = null;
        if (node instanceof Element) {
            if (declaredStyle != null) {
                propertyValue = declaredStyle.getValue(SupportedProperty.TEXT_ALIGN);
            }
            if (propertyValue == null && computedParentStyle != null) {
                propertyValue = computedParentStyle.getValue(SupportedProperty.TEXT_ALIGN);
            }
            if (propertyValue == null) {
                propertyValue = Value.LEFT.getCSSValue();
            }
        }
        return propertyValue;
    }

    @Override
    public CSSPropertySwingStyler getSwingStyler(StyleProperties<String> computedStyle) {
        return Value.forCssValue(computedStyle.getValue(SupportedProperty.TEXT_ALIGN));
    }

    public static enum Value implements CSSPropertySwingStyler
    {
        LEFT("left", 2),
        CENTER("center", 0),
        RIGHT("right", 4);

        private final String cssValue;
        private final int swingConstant;
        private static Map<String, Value> cache;

        static {
            cache = new HashMap<String, Value>();
        }

        private Value(String cssValue, int swingConstant) {
            this.cssValue = cssValue;
            this.swingConstant = swingConstant;
        }

        @Override
        public String getCSSValue() {
            return this.cssValue;
        }

        @Override
        public void applyTo(JComponent component) {
            if (component instanceof JLabel) {
                ((JLabel)component).setHorizontalAlignment(this.swingConstant);
            }
        }

        private static Value forCssValue(String cssValue) {
            if (cache.isEmpty()) {
                Value.buildCache();
            }
            if (cache.containsKey(cssValue)) {
                return cache.get(cssValue);
            }
            throw new IllegalArgumentException("Text align type \"" + cssValue + "\" is not supported.");
        }

        private static void buildCache() {
            Value[] valueArray = Value.values();
            int n = valueArray.length;
            int n2 = 0;
            while (n2 < n) {
                Value each = valueArray[n2];
                cache.put(each.getCSSValue(), each);
                ++n2;
            }
        }
    }
}

