/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.css.property;

import com.ur.urcap.html.css.CSSPropertySwingStyler;
import com.ur.urcap.html.css.StyleProperties;
import com.ur.urcap.html.css.property.PropertyDescriptor;
import com.ur.urcap.html.css.property.SizeUtils;
import com.ur.urcap.html.css.property.SupportedProperty;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.jsoup.nodes.Node;

class WidthDescriptor
implements PropertyDescriptor {
    WidthDescriptor() {
    }

    @Override
    public String getPropertyName() {
        return "width";
    }

    @Override
    public String computeValueFor(Node node, StyleProperties<String> computedParentStyle, StyleProperties<String> declaredStyle) {
        int size;
        String userValue;
        String parentValue = computedParentStyle.getValue(SupportedProperty.WIDTH);
        int parentSize = -1;
        if (parentValue != null) {
            parentSize = SizeUtils.getSize(parentValue);
        }
        String result = null;
        if (declaredStyle != null && (userValue = declaredStyle.getValue(SupportedProperty.WIDTH)) != null && (size = SizeUtils.getSize(userValue, parentSize)) >= 0) {
            result = String.valueOf(Integer.toString(size)) + "px";
        }
        return result;
    }

    @Override
    public CSSPropertySwingStyler getSwingStyler(StyleProperties<String> computedStyle) {
        return new WidthValue(computedStyle.getValue(SupportedProperty.WIDTH));
    }

    private final class WidthValue
    implements CSSPropertySwingStyler {
        private final int size;

        private WidthValue(String cssValue) {
            this.size = SizeUtils.getSize(cssValue);
        }

        @Override
        public void applyTo(JComponent component) {
            Dimension preferredSize = component.getPreferredSize();
            Dimension newPreferredSize = new Dimension(this.size, preferredSize.height);
            component.setPreferredSize(newPreferredSize);
        }

        @Override
        public String getCSSValue() {
            return Integer.toString(this.size);
        }
    }
}

