/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.impl;

import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.resources.ViewImageResource;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.SwingUtil;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.feature.FeatureLine;
import com.ur.urcap.api.domain.feature.FeaturePlane;
import com.ur.urcap.api.domain.feature.FeaturePoint;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.ui.component.Translatable;
import com.ur.urcap.domain.variable.AbstractVariable;
import com.ur.urcap.html.impl.RenderingStrategyProvider;
import com.ur.urcap.html.impl.URCapSelectListModelImpl;
import com.ur.view.Settings;
import com.ur.view.variables.core.Variable;
import gui.polyscope.setup.treenodes.geom.GeomLineNode;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.program.services.GeomFeatureVariable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.inject.Inject;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.apache.commons.lang3.text.WordUtils;

public class ComboBoxCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final char[] WORD_SEPARATORS = new char[]{'_'};
    private static final Color DEFAULT_BACKGROUND = UIManager.getColor("ComboBox.background");
    private static final Color UNDEFINED_WARNING_COLOR = UIManager.getColor("undefined.warning");
    private final JComboBox comboBox;
    private final Border errorBorder;
    private final Border originalBorder;
    private final URCapSelectListModelImpl listModel;
    private static RenderingStrategyProvider renderingStrategyProvider;
    private final JList jlist;

    public ComboBoxCellRenderer(URCapSelectListModelImpl listModel, JList jlist) {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.listModel = listModel;
        this.jlist = jlist;
        this.comboBox = null;
        this.errorBorder = null;
        this.originalBorder = null;
    }

    public ComboBoxCellRenderer(JComboBox comboBox) {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.listModel = null;
        this.jlist = null;
        this.comboBox = comboBox;
        this.originalBorder = comboBox.getBorder();
        this.errorBorder = this.buildErrorBorder(this.originalBorder);
    }

    private Border buildErrorBorder(Border originalBorder) {
        AbstractBorder spaceAroundOriginalBorder = new EmptyBorder(new Insets(1, 1, 1, 1));
        if (originalBorder != null) {
            spaceAroundOriginalBorder = new CompoundBorder(spaceAroundOriginalBorder, originalBorder);
        }
        return new CompoundBorder(new LineBorder(UNDEFINED_WARNING_COLOR, 2), spaceAroundOriginalBorder);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size;
        if (this.getText() == null || this.getText().isEmpty()) {
            this.setText(" ");
            size = super.getPreferredSize();
            this.setText("");
        } else {
            size = super.getPreferredSize();
        }
        return size;
    }

    public synchronized Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (this.comboBox != null && this.comboBox.getItemCount() == 0) {
            this.comboBox.setFont(this.getFont().deriveFont(0));
            this.comboBox.setBorder(this.originalBorder);
        }
        this.setFont(list.getFont());
        if (value instanceof Translatable) {
            Translatable translatable = (Translatable)value;
            this.setText(translatable.getTranslatedText(Settings.getLanguage().getLocale()));
            this.setIcon(null);
        } else if (value instanceof Icon) {
            this.setText("");
            this.setIcon((Icon)value);
        } else if (value instanceof Enum) {
            this.setText(this.getEnumText((Enum)value));
            this.setIcon(null);
        } else if (value instanceof IO) {
            IO io = (IO)value;
            this.setText(io.getName());
            this.setIcon(null);
        } else if (value instanceof Feature) {
            Feature feature = (Feature)value;
            this.setText(feature.getName());
            boolean isDefined = feature.isDefined();
            this.setFeatureIcon(isDefined, feature.getClass());
        } else if (value instanceof AbstractVariable) {
            this.doVariableRenderer((AbstractVariable)value, isSelected, index);
        } else if (value instanceof TCP) {
            this.doTCPRenderer((TCP)value, isSelected, index);
        } else if (value instanceof Payload) {
            this.doPayloadRenderer((Payload)value, isSelected, index);
        } else {
            this.setText(value == null ? "" : value.toString());
            this.setIcon(null);
        }
        return this;
    }

    private void doTCPRenderer(TCP tcp, boolean isSelected, int index) {
        boolean isResolvable = tcp.isResolvable();
        this.setIcon(null);
        this.setTextAndBackground(tcp.getDisplayName(), isSelected, isResolvable);
        this.setBorder(index, isResolvable, true);
    }

    private void doPayloadRenderer(Payload payload, boolean isSelected, int index) {
        boolean isResolvable = payload.isResolvable();
        this.setIcon(this.getPayloadRenderingStrategy().getIcon((Object)payload));
        this.setTextAndBackground(payload.getDisplayName(), isSelected, isResolvable);
        this.setBorder(index, isResolvable, true);
    }

    private RenderingStrategy getPayloadRenderingStrategy() {
        return renderingStrategyProvider.getPayloadRenderingStrategy();
    }

    private void setFeatureIcon(boolean isDefined, Class<? extends Feature> featureClass) {
        if (FeaturePoint.class.isAssignableFrom(featureClass)) {
            this.setIcon(isDefined ? ViewImageResource.programnodeGeomPointOk() : ViewImageResource.programnodeGeomPointUndefined());
        } else if (FeatureLine.class.isAssignableFrom(featureClass)) {
            this.setIcon(isDefined ? ViewImageResource.programnodeGeomLineOk() : ViewImageResource.programnodeGeomLineUndefined());
        } else if (FeaturePlane.class.isAssignableFrom(featureClass)) {
            this.setIcon(isDefined ? ViewImageResource.programnodeGeomPlaneOk() : ViewImageResource.programnodeGeomPlaneUndefined());
        } else {
            this.setIcon(null);
        }
    }

    private void setFeatureVariableIcon(AbstractVariable variable) {
        Variable realVar = variable.getRealVariable();
        if (realVar instanceof GeomFeatureVariable) {
            GeomFeatureVariable geomFeatureVariable = (GeomFeatureVariable)realVar;
            GeomFeature feature = geomFeatureVariable.dereference();
            if (feature != null) {
                boolean isDefined;
                boolean bl = isDefined = !feature.isUndefined();
                if (feature instanceof GeomPoseNode) {
                    this.setFeatureIcon(isDefined, FeaturePoint.class);
                } else if (feature instanceof GeomLineNode) {
                    this.setFeatureIcon(isDefined, FeatureLine.class);
                } else if (feature instanceof GeomPlaneNode) {
                    this.setFeatureIcon(isDefined, FeaturePlane.class);
                } else {
                    this.setIcon(null);
                }
            } else {
                this.setIcon(null);
            }
        }
    }

    private void doVariableRenderer(AbstractVariable variable, boolean isSelected, int index) {
        boolean isRegistered = variable.isRegistered();
        boolean isVisibleIfSelected = variable.getType() == Variable.Type.VALUE_PERSISTED || variable.getType() == Variable.Type.FEATURE;
        this.setVariableIcon(variable);
        this.setTextAndBackground(variable, isSelected, isRegistered, isVisibleIfSelected);
        this.setBorder(index, isRegistered, isVisibleIfSelected);
    }

    private void setVariableIcon(AbstractVariable variable) {
        if (variable.getType() == Variable.Type.FEATURE) {
            this.setFeatureVariableIcon(variable);
        } else {
            this.setIcon(null);
        }
    }

    private void setBorder(int index, boolean isRegistered, boolean isVisibleIfSelected) {
        if (index == -1) {
            if (isVisibleIfSelected && !isRegistered) {
                if (this.comboBox != null) {
                    this.comboBox.setFont(this.getFont().deriveFont(2));
                    this.comboBox.setBorder(this.errorBorder);
                }
            } else if (this.comboBox != null) {
                this.comboBox.setFont(this.getFont().deriveFont(0));
                this.comboBox.setBorder(this.originalBorder);
            }
        }
    }

    private void setTextAndBackground(AbstractVariable variable, boolean isSelected, boolean isRegistered, boolean isVisibleIfSelected) {
        if (!isRegistered) {
            if (isVisibleIfSelected) {
                this.setItemWithErrorVisible(variable.getDisplayName(), isSelected);
            } else if (this.listModel != null) {
                this.setItemInvisible();
                SwingUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ComboBoxCellRenderer.this.listModel.update();
                    }
                });
            }
        } else {
            this.setItemVisible(variable.getDisplayName(), isSelected);
        }
    }

    private void setTextAndBackground(String displayName, boolean isSelected, boolean isResolvable) {
        if (!isResolvable) {
            if (isSelected) {
                this.setItemWithErrorVisible(displayName, isSelected);
            } else if (this.listModel != null) {
                this.setItemInvisible();
                SwingUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ComboBoxCellRenderer.this.listModel.update();
                    }
                });
            }
        } else {
            this.setItemVisible(displayName, isSelected);
        }
    }

    private void setItemInvisible() {
        this.setEnabled(false);
        this.setText("");
        this.setIcon(null);
    }

    private void setItemWithErrorVisible(String text, boolean isSelected) {
        this.setItemVisible(text, isSelected, true);
    }

    private void setItemVisible(String text, boolean isSelected) {
        this.setItemVisible(text, isSelected, false);
    }

    private void setItemVisible(String text, boolean isSelected, boolean hasError) {
        this.setVisible(true);
        this.setPreferredSize(null);
        this.setEnabled(true);
        this.setText(text);
        if (hasError) {
            if (this.comboBox != null) {
                this.setFont(this.getFont().deriveFont(2));
                this.setBackground(UNDEFINED_WARNING_COLOR);
            } else if (this.jlist != null) {
                this.setBackground(UNDEFINED_WARNING_COLOR);
                this.setForeground(this.jlist.getForeground());
            }
        } else if (this.comboBox != null) {
            this.setFont(this.getFont().deriveFont(0));
            this.setBackground(DEFAULT_BACKGROUND);
        } else if (this.jlist != null) {
            if (isSelected) {
                this.setBackground(this.jlist.getSelectionBackground());
                this.setForeground(this.jlist.getSelectionForeground());
            } else {
                this.setBackground(this.jlist.getBackground());
                this.setForeground(this.jlist.getForeground());
            }
        }
    }

    private String getEnumText(Enum<?> enumeration) {
        String enumString = WordUtils.capitalizeFully((String)enumeration.toString(), (char[])WORD_SEPARATORS);
        enumString = WordUtils.capitalize((String)enumString);
        char[] cArray = WORD_SEPARATORS;
        int n = WORD_SEPARATORS.length;
        int n2 = 0;
        while (n2 < n) {
            char separator = cArray[n2];
            enumString = enumString.replaceAll(Character.toString(separator), " ");
            ++n2;
        }
        return enumString;
    }

    @Inject
    public static void setRenderingStrategyProvider(RenderingStrategyProvider renderingStrategyProvider) {
        ComboBoxCellRenderer.renderingStrategyProvider = renderingStrategyProvider;
    }
}

