/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.impl;

import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.domain.variable.AbstractVariable;
import com.ur.urcap.html.SelectionChangedListener;
import com.ur.urcap.html.impl.UIUpdate;
import com.ur.urcap.html.impl.URCapDropDownListModel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public final class URCapDropDownListModelImpl
implements URCapDropDownListModel,
ItemListener {
    private JComboBox swingJComboBox;
    private ArrayList items = new ArrayList();
    private DefaultComboBoxModel swingModel;
    private final UIUpdate ui;
    private Object lastKnownSelection = null;

    public URCapDropDownListModelImpl(JComboBox comboBox, DefaultComboBoxModel swingModel, UIUpdate ui) {
        this.swingJComboBox = comboBox;
        this.swingModel = swingModel;
        this.ui = ui;
        this.swingJComboBox.addItemListener(this);
    }

    @Override
    public synchronized void setItems(List<?> list) {
        this.items.clear();
        this.items.addAll(list);
        ArrayList<ItemListener> removedListeners = this.unregisterSelectionListeners();
        try {
            if (!list.isEmpty()) {
                this.lastKnownSelection = list.get(0);
            }
            this.swingModel.removeAllElements();
            for (Object o : this.items) {
                if (!this.isVisible(o)) continue;
                this.swingModel.addElement(o);
            }
        }
        finally {
            this.registerSelectionListeners(removedListeners);
        }
    }

    @Override
    public synchronized void addItem(Object o) {
        ArrayList<ItemListener> removedListeners = this.unregisterSelectionListeners();
        try {
            if (this.items.isEmpty()) {
                this.lastKnownSelection = o;
            }
            this.items.add(o);
            if (this.isVisible(o)) {
                this.swingModel.addElement(o);
            }
        }
        finally {
            this.registerSelectionListeners(removedListeners);
        }
    }

    @Override
    public synchronized void removeAllItems() {
        this.items.clear();
        this.swingModel.removeAllElements();
        this.lastKnownSelection = null;
    }

    @Override
    public synchronized int getItemCount() {
        return this.items.size();
    }

    @Override
    public synchronized void selectItem(Object o) {
        this.lastKnownSelection = o;
        this.swingModel.setSelectedItem(o);
    }

    @Override
    public synchronized void selectItemAtIndex(int index) {
        if (index == -1) {
            this.lastKnownSelection = null;
            this.swingModel.setSelectedItem(null);
            return;
        }
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        Object item = this.items.get(index);
        this.selectItem(item);
    }

    @Override
    public synchronized int getSelectedIndex() {
        Object selectedItem = this.getSelectedItem();
        return this.items.indexOf(selectedItem);
    }

    @Override
    public synchronized Object getSelectedItem() {
        return this.lastKnownSelection;
    }

    @Override
    public synchronized void update() {
        if (this.items.isEmpty()) {
            return;
        }
        ArrayList<ItemListener> removedListeners = this.unregisterSelectionListeners();
        try {
            Object selected = this.swingModel.getSelectedItem();
            ArrayList newList = new ArrayList();
            for (Object o : this.items) {
                if (!this.isVisible(o)) continue;
                newList.add(o);
            }
            this.swingModel.removeAllElements();
            for (Object o : newList) {
                this.swingModel.addElement(o);
            }
            this.swingModel.setSelectedItem(selected);
            if (this.lastKnownSelection != null) {
                this.selectItem(this.lastKnownSelection);
            } else {
                this.lastKnownSelection = this.swingModel.getSelectedItem();
            }
        }
        finally {
            this.registerSelectionListeners(removedListeners);
        }
        this.ui.update();
    }

    private void registerSelectionListeners(ArrayList<ItemListener> removedListeners) {
        for (ItemListener l : removedListeners) {
            this.swingJComboBox.addItemListener(l);
        }
    }

    private ArrayList<ItemListener> unregisterSelectionListeners() {
        ItemListener[] listeners = this.swingJComboBox.getItemListeners();
        ArrayList<ItemListener> removedListeners = new ArrayList<ItemListener>();
        ItemListener[] itemListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ItemListener l = itemListenerArray[n2];
            if (l == this) {
                removedListeners.add(l);
                this.swingJComboBox.removeItemListener(l);
            } else if (l instanceof SelectionChangedListener) {
                removedListeners.add(l);
                this.swingJComboBox.removeItemListener(l);
            }
            ++n2;
        }
        return removedListeners;
    }

    private boolean isVisible(Object item) {
        if (!this.items.contains(item)) {
            return false;
        }
        if (item instanceof AbstractVariable) {
            AbstractVariable variable = (AbstractVariable)item;
            if (variable.isRegistered() || this.isVisibleAndSelected(variable)) {
                return true;
            }
        } else if (item instanceof TCP) {
            TCP tcp = (TCP)item;
            if (tcp.isResolvable() || this.isSelected(tcp)) {
                return true;
            }
        } else if (item instanceof Payload) {
            Payload payload = (Payload)item;
            if (payload.isResolvable() || this.isSelected(payload)) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean isSelected(Object item) {
        return this.swingModel.getSelectedItem() == item;
    }

    private boolean isVisibleAndSelected(AbstractVariable variable) {
        boolean isVisibleIfSelected;
        boolean bl = isVisibleIfSelected = variable.getType() == Variable.Type.VALUE_PERSISTED || variable.getType() == Variable.Type.FEATURE;
        return isVisibleIfSelected && this.isSelected(variable);
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src == null) {
            return;
        }
        if (!(src instanceof JComboBox)) {
            return;
        }
        JComboBox jcb = (JComboBox)e.getSource();
        if (jcb.getModel() != this.swingModel) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.onItemEvent();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    URCapDropDownListModelImpl.this.onItemEvent();
                }
            });
        }
    }

    private void onItemEvent() {
        this.lastKnownSelection = this.swingJComboBox.getSelectedItem();
        this.update();
    }
}

