/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.impl;

import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.resources.ViewImageResource;
import com.ur.swing.RenderingStrategy;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.feature.FeatureLine;
import com.ur.urcap.api.domain.feature.FeaturePlane;
import com.ur.urcap.api.domain.feature.FeaturePoint;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.io.ModbusIO;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.api.ui.component.Translatable;
import com.ur.urcap.domain.variable.AbstractVariable;
import com.ur.urcap.html.impl.RenderingStrategyProvider;
import com.ur.view.Settings;
import com.ur.view.variables.core.Variable;
import gui.polyscope.setup.treenodes.geom.GeomLineNode;
import gui.polyscope.setup.treenodes.geom.GeomPlaneNode;
import gui.polyscope.setup.treenodes.geom.GeomPoseNode;
import gui.program.services.GeomFeatureVariable;
import javax.inject.Inject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import org.apache.commons.lang3.text.WordUtils;

public class URCapDropdownRenderingStrategy
implements RenderingStrategy {
    private static final char[] WORD_SEPARATORS = new char[]{'_'};
    private static RenderingStrategyProvider renderingStrategyProvider;
    private DefaultComboBoxModel model;

    public URCapDropdownRenderingStrategy(DefaultComboBoxModel model) {
        this.model = model;
    }

    public String getText(Object value) {
        if (value instanceof Translatable) {
            Translatable translatable = (Translatable)value;
            return translatable.getTranslatedText(Settings.getLanguage().getLocale());
        }
        if (value instanceof Icon) {
            return "";
        }
        if (value instanceof Enum) {
            return this.getEnumText((Enum)value);
        }
        if (value instanceof IO) {
            IO io = (IO)value;
            return io.getName();
        }
        if (value instanceof Feature) {
            Feature feature = (Feature)value;
            return feature.getName();
        }
        if (value instanceof AbstractVariable) {
            return ((AbstractVariable)value).getDisplayName();
        }
        if (value instanceof TCP) {
            return ((TCP)value).getDisplayName();
        }
        if (value instanceof Payload) {
            return this.getPayloadRenderingStrategy().getText(value);
        }
        return value == null ? "" : value.toString();
    }

    public Icon getIcon(Object value) {
        if (value instanceof Translatable) {
            return null;
        }
        if (value instanceof Icon) {
            return (Icon)value;
        }
        if (value instanceof Enum) {
            return null;
        }
        if (value instanceof IO) {
            return null;
        }
        if (value instanceof Feature) {
            Feature feature = (Feature)value;
            if (feature.isResolvable()) {
                return this.getFeatureIcon(feature.isDefined(), feature.getClass());
            }
            return null;
        }
        if (value instanceof AbstractVariable) {
            AbstractVariable variable = (AbstractVariable)value;
            if (variable.getType() == Variable.Type.FEATURE) {
                return this.getFeatureVariableIcon(variable);
            }
            return null;
        }
        if (value instanceof Payload) {
            Payload payload = (Payload)value;
            return this.getPayloadIcon(payload);
        }
        return null;
    }

    private Icon getPayloadIcon(Payload payload) {
        return this.getPayloadRenderingStrategy().getIcon((Object)payload);
    }

    private RenderingStrategy getPayloadRenderingStrategy() {
        return renderingStrategyProvider.getPayloadRenderingStrategy();
    }

    public boolean hasError(Object value) {
        if (this.isTypeWithNoErrorCheck(value)) {
            return false;
        }
        if (value instanceof IO) {
            if (value instanceof ModbusIO) {
                return !this.modelContains(value);
            }
            return false;
        }
        if (value instanceof Feature) {
            return !((Feature)value).isResolvable();
        }
        if (value instanceof AbstractVariable) {
            return !((AbstractVariable)value).isRegistered();
        }
        if (value instanceof TCP) {
            return !((TCP)value).isResolvable();
        }
        if (value instanceof Payload) {
            return this.getPayloadRenderingStrategy().hasError(value);
        }
        return false;
    }

    private boolean isTypeWithNoErrorCheck(Object value) {
        return value instanceof Translatable || value instanceof Icon || value instanceof Enum;
    }

    private boolean modelContains(Object value) {
        int i = 0;
        while (i < this.model.getSize()) {
            Object item = this.model.getElementAt(i);
            if (item instanceof ModbusIO && value instanceof ModbusIO && this.hasSameName((ModbusIO)value, (ModbusIO)item)) {
                return true;
            }
            if (item.equals(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasSameName(ModbusIO value, ModbusIO item) {
        return value.getName().equals(item.getName());
    }

    private Icon getFeatureVariableIcon(AbstractVariable variable) {
        Variable realVar = variable.getRealVariable();
        if (realVar instanceof GeomFeatureVariable) {
            GeomFeatureVariable geomFeatureVariable = (GeomFeatureVariable)realVar;
            GeomFeature feature = geomFeatureVariable.dereference();
            if (feature != null) {
                boolean isDefined;
                boolean bl = isDefined = !feature.isUndefined();
                if (feature instanceof GeomPoseNode) {
                    return this.getFeatureIcon(isDefined, FeaturePoint.class);
                }
                if (feature instanceof GeomLineNode) {
                    return this.getFeatureIcon(isDefined, FeatureLine.class);
                }
                if (feature instanceof GeomPlaneNode) {
                    return this.getFeatureIcon(isDefined, FeaturePlane.class);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private Icon getFeatureIcon(boolean isDefined, Class<? extends Feature> featureClass) {
        if (FeaturePoint.class.isAssignableFrom(featureClass)) {
            return isDefined ? ViewImageResource.programnodeGeomPointOk() : ViewImageResource.programnodeGeomPointUndefined();
        }
        if (FeatureLine.class.isAssignableFrom(featureClass)) {
            return isDefined ? ViewImageResource.programnodeGeomLineOk() : ViewImageResource.programnodeGeomLineUndefined();
        }
        if (FeaturePlane.class.isAssignableFrom(featureClass)) {
            return isDefined ? ViewImageResource.programnodeGeomPlaneOk() : ViewImageResource.programnodeGeomPlaneUndefined();
        }
        return null;
    }

    private String getEnumText(Enum<?> enumeration) {
        String enumString = WordUtils.capitalizeFully((String)enumeration.toString(), (char[])WORD_SEPARATORS);
        enumString = WordUtils.capitalize((String)enumString);
        char[] cArray = WORD_SEPARATORS;
        int n = WORD_SEPARATORS.length;
        int n2 = 0;
        while (n2 < n) {
            char separator = cArray[n2];
            enumString = enumString.replaceAll(Character.toString(separator), " ");
            ++n2;
        }
        return enumString;
    }

    @Inject
    public static void setRenderingStrategyProvider(RenderingStrategyProvider renderingStrategyProvider) {
        URCapDropdownRenderingStrategy.renderingStrategyProvider = renderingStrategyProvider;
    }
}

