/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.impl;

import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.variable.Variable;
import com.ur.urcap.domain.variable.AbstractVariable;
import com.ur.urcap.html.SelectionChangedListener;
import com.ur.urcap.html.impl.URCapSelectListModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.ArrayUtils;

public class URCapSelectListModelImpl
implements URCapSelectListModel,
ListSelectionListener {
    private JList swingJList;
    private ArrayList elements = new ArrayList();
    private DefaultListModel swingModel;
    private Object[] lastKnownSelectionObjects;

    public URCapSelectListModelImpl(JList list, DefaultListModel listModel) {
        this.swingJList = list;
        this.swingModel = listModel;
        this.swingJList.addListSelectionListener(this);
    }

    @Override
    public synchronized void setItems(List<?> items) {
        this.elements.clear();
        this.elements.addAll(items);
        this.swingModel.clear();
        for (Object item : items) {
            this.swingModel.addElement(item);
        }
    }

    @Override
    public synchronized void addItem(Object item) {
        ArrayList<ListSelectionListener> removedListeners = this.unregisterSelectionListeners();
        try {
            this.elements.add(item);
            this.swingModel.addElement(item);
        }
        finally {
            this.registerSelectionListeners(removedListeners);
        }
    }

    @Override
    public synchronized void addAllItems(List<?> items) {
        for (Object each : items) {
            this.addItem(each);
        }
    }

    @Override
    public synchronized void removeItem(Object item) {
        this.elements.remove(item);
        this.swingModel.removeElement(item);
        this.lastKnownSelectionObjects = this.removeUnknownObjects(this.lastKnownSelectionObjects);
    }

    @Override
    public synchronized void removeAllItems() {
        ArrayList<ListSelectionListener> removedListeners = this.unregisterSelectionListeners();
        try {
            this.elements.clear();
            this.swingModel.clear();
            this.lastKnownSelectionObjects = null;
        }
        finally {
            this.registerSelectionListeners(removedListeners);
        }
    }

    @Override
    public synchronized void clearSelection() {
        try {
            this.swingJList.removeListSelectionListener(this);
            this.lastKnownSelectionObjects = null;
            this.swingJList.clearSelection();
        }
        finally {
            this.swingJList.addListSelectionListener(this);
        }
    }

    @Override
    public synchronized void selectItems(Object ... itemsToSelect) {
        this.lastKnownSelectionObjects = this.removeUnknownObjects(itemsToSelect);
        if (itemsToSelect == null) {
            this.clearSelection();
            return;
        }
        this.update();
    }

    @Override
    public synchronized void selectItemsAtIndices(int ... indices) {
        if (indices == null) {
            this.lastKnownSelectionObjects = null;
            this.clearSelection();
            return;
        }
        ArrayList selectedList = new ArrayList();
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index >= 0 && index < this.elements.size()) {
                Object element = this.elements.get(index);
                selectedList.add(element);
            }
            ++i;
        }
        this.selectItems(selectedList.toArray());
    }

    @Override
    public synchronized int getItemCount() {
        return this.elements.size();
    }

    @Override
    public synchronized Object[] getSelectedItems() {
        if (this.lastKnownSelectionObjects != null) {
            return this.removeInvisibleObjects(this.lastKnownSelectionObjects);
        }
        Object[] realSelectedItems = this.swingJList.getSelectedValues();
        ArrayList<Object> proxySelectedList = new ArrayList<Object>();
        Object[] objectArray = realSelectedItems;
        int n = realSelectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (this.isVisible(o)) {
                proxySelectedList.add(o);
            }
            ++n2;
        }
        return proxySelectedList.toArray();
    }

    private Object[] removeInvisibleObjects(Object ... objects) {
        ArrayList<Object> selectedAndVisible = new ArrayList<Object>();
        int i = 0;
        while (i < objects.length) {
            if (this.isVisible(objects[i])) {
                selectedAndVisible.add(objects[i]);
            }
            ++i;
        }
        return selectedAndVisible.toArray();
    }

    private Object[] removeUnknownObjects(Object ... objects) {
        if (objects == null) {
            return new Object[0];
        }
        ArrayList<Object> selectedAndVisible = new ArrayList<Object>();
        int i = 0;
        while (i < objects.length) {
            if (this.elements.contains(objects[i])) {
                selectedAndVisible.add(objects[i]);
            }
            ++i;
        }
        return selectedAndVisible.toArray();
    }

    @Override
    public synchronized Object getSelectedItem() {
        Object[] visible;
        if (this.lastKnownSelectionObjects != null && (visible = this.removeInvisibleObjects(this.lastKnownSelectionObjects)).length > 0) {
            return visible[0];
        }
        return null;
    }

    @Override
    public synchronized int getSelectedIndex() {
        Object selectedItem = this.getSelectedItem();
        return this.elements.indexOf(selectedItem);
    }

    @Override
    public synchronized int[] getSelectedIndices() {
        Object[] selectedItems = this.getSelectedItems();
        return this.getIndicesOfItems(selectedItems);
    }

    @Override
    public synchronized Object[] getItems() {
        return this.elements.toArray();
    }

    @Override
    public synchronized void refresh() {
        this.swingJList.repaint();
    }

    private int[] getRealIndicesOfItems(Object[] itemsToSelect) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int i = 0;
        while (i < itemsToSelect.length) {
            int ind = this.swingModel.indexOf(itemsToSelect[i]);
            if (ind >= 0) {
                indices.add(ind);
            }
            ++i;
        }
        return ArrayUtils.toPrimitive((Integer[])indices.toArray(new Integer[0]));
    }

    private int[] getIndicesOfItems(Object[] itemsToSelect) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int i = 0;
        while (i < itemsToSelect.length) {
            int ind = this.elements.indexOf(itemsToSelect[i]);
            if (ind >= 0) {
                indices.add(ind);
            }
            ++i;
        }
        return ArrayUtils.toPrimitive((Integer[])indices.toArray(new Integer[0]));
    }

    private boolean isVisible(Object item) {
        if (!this.elements.contains(item)) {
            return false;
        }
        if (item instanceof AbstractVariable) {
            AbstractVariable variable = (AbstractVariable)item;
            if (variable.isRegistered() || this.isVisibleAndSelected(variable)) {
                return true;
            }
        } else if (item instanceof TCP) {
            TCP tcp = (TCP)item;
            if (tcp.isResolvable() || this.isSelected(tcp)) {
                return true;
            }
        } else if (item instanceof Payload) {
            Payload payload = (Payload)item;
            if (payload.isResolvable() || this.isSelected(payload)) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean isVisibleAndSelected(AbstractVariable variable) {
        boolean isVisibleIfSelected;
        boolean bl = isVisibleIfSelected = variable.getType() == Variable.Type.VALUE_PERSISTED || variable.getType() == Variable.Type.FEATURE;
        return isVisibleIfSelected && this.isSelected(variable);
    }

    private boolean isSelected(Object variable) {
        if (this.lastKnownSelectionObjects == null) {
            return false;
        }
        return Arrays.asList(this.lastKnownSelectionObjects).contains(variable);
    }

    @Override
    public synchronized void update() {
        ArrayList<ListSelectionListener> removedListeners = this.unregisterSelectionListeners();
        try {
            Object[] selectedItems = this.lastKnownSelectionObjects != null ? this.lastKnownSelectionObjects : new Object[]{};
            ArrayList newModelState = new ArrayList();
            for (Object each : this.elements) {
                if (!this.isVisible(each)) continue;
                newModelState.add(each);
            }
            this.swingModel.clear();
            for (Object o : newModelState) {
                this.swingModel.addElement(o);
            }
            int[] realSelected = this.getRealIndicesOfItems(selectedItems);
            this.swingJList.setSelectedIndices(realSelected);
        }
        finally {
            this.registerSelectionListeners(removedListeners);
        }
    }

    private void registerSelectionListeners(ArrayList<ListSelectionListener> removedListeners) {
        for (ListSelectionListener l : removedListeners) {
            this.swingJList.addListSelectionListener(l);
        }
    }

    private ArrayList<ListSelectionListener> unregisterSelectionListeners() {
        ListSelectionListener[] listeners = this.swingJList.getListSelectionListeners();
        ArrayList<ListSelectionListener> removedListeners = new ArrayList<ListSelectionListener>();
        ListSelectionListener[] listSelectionListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ListSelectionListener l = listSelectionListenerArray[n2];
            if (l == this) {
                removedListeners.add(l);
                this.swingJList.removeListSelectionListener(l);
            } else if (l instanceof SelectionChangedListener) {
                removedListeners.add(l);
                this.swingJList.removeListSelectionListener(l);
            }
            ++n2;
        }
        return removedListeners;
    }

    @Override
    public synchronized void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (src == null) {
            return;
        }
        if (!(src instanceof JList)) {
            return;
        }
        JList jl = (JList)src;
        if (jl.getModel() != this.swingModel) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.removeUnselectedInvisibleElements();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    URCapSelectListModelImpl.this.removeUnselectedInvisibleElements();
                }
            });
        }
    }

    private void removeUnselectedInvisibleElements() {
        this.lastKnownSelectionObjects = this.swingJList.getSelectedValues();
        ArrayList toRemove = new ArrayList();
        int i = 0;
        while (i < this.swingModel.getSize()) {
            Object o = this.swingModel.getElementAt(i);
            if (!this.isVisible(o)) {
                toRemove.add(o);
            }
            ++i;
        }
        for (Object o : toRemove) {
            this.swingModel.removeElement(o);
        }
    }
}

