/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.html.util;

import org.apache.commons.lang.StringEscapeUtils;

public class HTMLBuilder {
    private final StringBuilder sb = new StringBuilder();

    public HTMLBuilder start(String tag) {
        this.sb.append("<").append(tag).append(">");
        return this;
    }

    public HTMLBuilder end(String tag) {
        this.sb.append("</").append(tag).append(">");
        return this;
    }

    public HTMLBuilder br() {
        this.sb.append("<br/>");
        return this;
    }

    public HTMLBuilder b(String text) {
        this.start("b");
        this.text(text);
        this.end("b");
        return this;
    }

    public HTMLBuilder text(String text) {
        String escaped = StringEscapeUtils.escapeHtml((String)text);
        this.sb.append(escaped);
        return this;
    }

    public HTMLBuilder appendHtml(String html) {
        this.sb.append(html);
        return this;
    }

    public HTMLBuilder nbsp() {
        this.sb.append("&nbsp;");
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }
}

