/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.installation.io;

import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.pin.AnalogIOPin;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.urcap.api.domain.io.AnalogIO;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.program.nodes.builtin.InvalidDomainException;
import com.ur.urcap.api.domain.value.simple.Current;
import com.ur.urcap.api.domain.value.simple.Voltage;
import com.ur.urcap.installation.io.AnalogIOImpl$AjcClosure1;
import com.ur.urcap.installation.io.AnalogIOImpl$AjcClosure11;
import com.ur.urcap.installation.io.AnalogIOImpl$AjcClosure3;
import com.ur.urcap.installation.io.AnalogIOImpl$AjcClosure5;
import com.ur.urcap.installation.io.AnalogIOImpl$AjcClosure7;
import com.ur.urcap.installation.io.AnalogIOImpl$AjcClosure9;
import com.ur.urcap.installation.io.ControllerSocketSender;
import com.ur.urcap.installation.io.PinIO;
import com.ur.util.logging.Log;
import java.util.Locale;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class AnalogIOImpl
extends PinIO
implements AnalogIO {
    public static final int _0_TO_10V = 1;
    public static final int _4_TO_20mA = 0;
    private ControllerInterface controllerInterface;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public AnalogIOImpl(Pin<?> ioPin, IO.IOType type, IO.InterfaceType interfaceType, ControllerInterface controllerInterface) {
        super(ioPin, type, interfaceType);
        this.controllerInterface = controllerInterface;
        if (type != IO.IOType.ANALOG) {
            throw new IllegalStateException("Expected an Analog IO type");
        }
    }

    public double getMinRangeValue() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        AnalogIOImpl$AjcClosure1 analogIOImpl$AjcClosure1 = new AnalogIOImpl$AjcClosure1(objectArray);
        return Conversions.doubleValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(analogIOImpl$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    public double getMaxRangeValue() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        AnalogIOImpl$AjcClosure3 analogIOImpl$AjcClosure3 = new AnalogIOImpl$AjcClosure3(objectArray);
        return Conversions.doubleValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(analogIOImpl$AjcClosure3.linkClosureAndJoinPoint(69648)));
    }

    private int getRangeType() {
        AnalogIOPin analogPin = (AnalogIOPin)this.ioPin;
        if (analogPin.isInput()) {
            return analogPin.getAnalogInputRange();
        }
        return analogPin.getAnalogOutputDomain();
    }

    public double getValue() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        AnalogIOImpl$AjcClosure5 analogIOImpl$AjcClosure5 = new AnalogIOImpl$AjcClosure5(objectArray);
        return Conversions.doubleValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(analogIOImpl$AjcClosure5.linkClosureAndJoinPoint(69648)));
    }

    public boolean setValue(double value) {
        double d = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.doubleObject((double)d));
        Object[] objectArray = new Object[]{this, Conversions.doubleObject((double)d), joinPoint};
        AnalogIOImpl$AjcClosure7 analogIOImpl$AjcClosure7 = new AnalogIOImpl$AjcClosure7(objectArray);
        return Conversions.booleanValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(analogIOImpl$AjcClosure7.linkClosureAndJoinPoint(69648)));
    }

    public boolean isCurrent() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        AnalogIOImpl$AjcClosure9 analogIOImpl$AjcClosure9 = new AnalogIOImpl$AjcClosure9(objectArray);
        return Conversions.booleanValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(analogIOImpl$AjcClosure9.linkClosureAndJoinPoint(69648)));
    }

    public boolean isVoltage() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        AnalogIOImpl$AjcClosure11 analogIOImpl$AjcClosure11 = new AnalogIOImpl$AjcClosure11(objectArray);
        return Conversions.booleanValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(analogIOImpl$AjcClosure11.linkClosureAndJoinPoint(69648)));
    }

    protected String convertToScriptValue(Object o) {
        this.assertIsOutput();
        double value = this.computeScriptValue(o);
        return String.format(Locale.ROOT, "%.6f", value);
    }

    private double computeScriptValue(Object o) {
        double computedValue;
        if (o instanceof Voltage) {
            computedValue = this.computeScriptVoltageValue((Voltage)o);
        } else if (o instanceof Current) {
            computedValue = this.computeScriptCurrentValue((Current)o);
        } else {
            if (o instanceof Float) {
                Float floatValue = (Float)o;
                return AnalogIOImpl.clamp(floatValue.floatValue(), 0.0, 1.0);
            }
            throw new IllegalArgumentException("Current or Voltage expected");
        }
        return computedValue;
    }

    private double computeScriptCurrentValue(Current current) {
        if (!this.isCurrent()) {
            throw new InvalidDomainException("Analog input is not configured as electrical current for pin: " + this.getIOPin().getDisplayName());
        }
        double value = current.getAs(Current.Unit.mA);
        value = AnalogIOImpl.clamp(value, 4.0, 20.0);
        return (value - 4.0) / 16.0;
    }

    private double computeScriptVoltageValue(Voltage voltage) {
        if (!this.isVoltage()) {
            throw new InvalidDomainException("Analog input is not configured to voltage for pin: " + this.getIOPin().getDisplayName());
        }
        double value = voltage.getAs(Voltage.Unit.V);
        value = AnalogIOImpl.clamp(value, 0.0, 10.0);
        return value / 10.0;
    }

    private static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    static {
        AnalogIOImpl.ajc$preClinit();
    }

    static final /* synthetic */ double getMinRangeValue_aroundBody0(AnalogIOImpl ajc$this, JoinPoint joinPoint) {
        int rangeType = ajc$this.getRangeType();
        switch (rangeType) {
            case 1: {
                return 0.0;
            }
            case 0: {
                return 0.004;
            }
        }
        Log.error((String)"Unknown analog I/O range type");
        return 0.0;
    }

    static final /* synthetic */ double getMaxRangeValue_aroundBody2(AnalogIOImpl ajc$this, JoinPoint joinPoint) {
        int rangeType = ajc$this.getRangeType();
        switch (rangeType) {
            case 1: {
                return 10.0;
            }
            case 0: {
                return 0.02;
            }
        }
        Log.error((String)"Unknown analog I/O range type");
        return 0.0;
    }

    static final /* synthetic */ double getValue_aroundBody4(AnalogIOImpl ajc$this, JoinPoint joinPoint) {
        return ((AnalogIOPin)ajc$this.ioPin).getValue();
    }

    static final /* synthetic */ boolean setValue_aroundBody6(AnalogIOImpl ajc$this, double value, JoinPoint joinPoint) {
        if (ajc$this.ioPin.isInput()) {
            Log.error((String)"Can only set value on Analog Output IO");
            return false;
        }
        if (ajc$this.getMinRangeValue() > value && value > ajc$this.getMaxRangeValue()) {
            Log.error((String)("Value must be between " + ajc$this.getMinRangeValue() + " and " + ajc$this.getMaxRangeValue()));
            return false;
        }
        if (!ajc$this.controllerInterface.isConnected()) {
            Log.error((String)"Controller is not connected");
            return false;
        }
        double scaledValue = (value - ajc$this.getMinRangeValue()) / (ajc$this.getMaxRangeValue() - ajc$this.getMinRangeValue());
        try {
            ControllerSocketSender.sendSetAnalogOut(ajc$this.ioPin.getPin(), scaledValue);
        }
        catch (Exception exception) {
            Log.error((String)"Failed to send value change to controller");
            return false;
        }
        return true;
    }

    static final /* synthetic */ boolean isCurrent_aroundBody8(AnalogIOImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.getRangeType() == 0;
    }

    static final /* synthetic */ boolean isVoltage_aroundBody10(AnalogIOImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.getRangeType() == 1;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AnalogIOImpl.java", AnalogIOImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMinRangeValue", "com.ur.urcap.installation.io.AnalogIOImpl", "", "", "", "double"), 35);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMaxRangeValue", "com.ur.urcap.installation.io.AnalogIOImpl", "", "", "", "double"), 51);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getValue", "com.ur.urcap.installation.io.AnalogIOImpl", "", "", "", "double"), 76);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setValue", "com.ur.urcap.installation.io.AnalogIOImpl", "double", "value", "", "boolean"), 81);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isCurrent", "com.ur.urcap.installation.io.AnalogIOImpl", "", "", "", "boolean"), 107);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isVoltage", "com.ur.urcap.installation.io.AnalogIOImpl", "", "", "", "boolean"), 112);
    }
}

