/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.installation.io;

import com.ur.polyscope.controllerinterface.ControllerInterface;
import javax.inject.Inject;

public final class ControllerSocketSender {
    private static final String END_PROGRAM = "end\n";
    private static final String SEC_SET_DIGITAL_OUT = "sec setDigitalOut():\n";
    private static ControllerInterface controllerInterface;

    private ControllerSocketSender() {
    }

    @Inject
    public static void setControllerInterface(ControllerInterface controllerInterface) {
        ControllerSocketSender.controllerInterface = controllerInterface;
    }

    public static void sendSetDigitalOut(int portNo, boolean val) {
        String b = "sec setDigitalOut():\n  digital_out[" + portNo + "] = " + ControllerSocketSender.toControllerBoolean(val) + "\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetConfigurableOut(int portNo, boolean val) {
        String b = "sec setDigitalOut():\n  set_configurable_digital_out(" + portNo + ", " + ControllerSocketSender.toControllerBoolean(val) + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetToolOut(int portNo, boolean val) {
        String b = "sec setDigitalOut():\n  set_tool_digital_out(" + portNo + ", " + ControllerSocketSender.toControllerBoolean(val) + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    public static void sendSetAnalogOut(int portNo, double val) {
        String b = "sec setStandardAnalogOut():\n  set_standard_analog_out(" + portNo + ", " + val + ")\n" + END_PROGRAM;
        controllerInterface.runScript(b);
    }

    static String toControllerBoolean(boolean b) {
        return b ? "True" : "False";
    }
}

