/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.installation.io;

import com.ur.lang.naming.NamingService;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.pin.urcaps.IOImpl;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.urcap.api.domain.io.IO;
import com.ur.urcap.api.domain.io.ModbusIO;
import com.ur.urcap.installation.io.ModbusIOImpl$AjcClosure1;
import com.ur.urcap.installation.io.ModbusIOImpl$AjcClosure3;
import com.ur.urcap.installation.io.ModbusIOImpl$AjcClosure5;
import com.ur.urcap.installation.io.ModbusIOImpl$AjcClosure7;
import com.ur.urcap.installation.io.ModbusIOImpl$AjcClosure9;
import com.ur.util.logging.Log;
import com.ur.view.modbus.ModbusSignal;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ModbusIOImpl
extends IOImpl
implements ModbusIO {
    private final ModbusSignal pin;
    private ControllerInterface controllerInterface;
    private NamingService namingService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public ModbusIOImpl(ModbusSignal pin, IO.IOType ioType, ControllerInterface controllerInterface, NamingService namingService) {
        super((Pin)pin, ioType, IO.InterfaceType.UR_MODBUS);
        this.controllerInterface = controllerInterface;
        this.namingService = namingService;
        if (ioType != IO.IOType.DIGITAL && ioType != IO.IOType.INTEGER) {
            throw new IllegalStateException("Expected a Digital or Integer IO type");
        }
        this.pin = pin;
    }

    public String getIpAddress() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        ModbusIOImpl$AjcClosure1 modbusIOImpl$AjcClosure1 = new ModbusIOImpl$AjcClosure1(objectArray);
        return (String)UncaughtExceptionAspect.aspectOf().aroundMethod(modbusIOImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public String getSignalAddress() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        ModbusIOImpl$AjcClosure3 modbusIOImpl$AjcClosure3 = new ModbusIOImpl$AjcClosure3(objectArray);
        return (String)UncaughtExceptionAspect.aspectOf().aroundMethod(modbusIOImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public boolean setValue(int value) {
        int n = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.intObject((int)n));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), joinPoint};
        ModbusIOImpl$AjcClosure5 modbusIOImpl$AjcClosure5 = new ModbusIOImpl$AjcClosure5(objectArray);
        return Conversions.booleanValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(modbusIOImpl$AjcClosure5.linkClosureAndJoinPoint(69648)));
    }

    public int getValue() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        ModbusIOImpl$AjcClosure7 modbusIOImpl$AjcClosure7 = new ModbusIOImpl$AjcClosure7(objectArray);
        return Conversions.intValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(modbusIOImpl$AjcClosure7.linkClosureAndJoinPoint(69648)));
    }

    public boolean isResolvable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        ModbusIOImpl$AjcClosure9 modbusIOImpl$AjcClosure9 = new ModbusIOImpl$AjcClosure9(objectArray);
        return Conversions.booleanValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(modbusIOImpl$AjcClosure9.linkClosureAndJoinPoint(69648)));
    }

    protected String convertToScriptValue(Object o) {
        String value;
        this.assertIsOutput();
        if (o instanceof Boolean) {
            value = this.computeScriptBooleanValue((Boolean)o);
        } else if (o instanceof Integer) {
            int intValue = (Integer)o;
            value = this.computeScriptIntegerRegisterValue(intValue);
        } else {
            throw new IllegalArgumentException("Boolean or Integer expected");
        }
        return this.ioPin.generateSetterScriptCode(value);
    }

    private String computeScriptBooleanValue(boolean value) {
        return value ? "True" : "False";
    }

    private String computeScriptIntegerRegisterValue(int intValue) {
        int clampedValue = ModbusIOImpl.clamp(intValue, 0, 65535);
        return String.valueOf(clampedValue);
    }

    private static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    static {
        ModbusIOImpl.ajc$preClinit();
    }

    static final /* synthetic */ String getIpAddress_aroundBody0(ModbusIOImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.pin.getModbusUnit().getIP();
    }

    static final /* synthetic */ String getSignalAddress_aroundBody2(ModbusIOImpl ajc$this, JoinPoint joinPoint) {
        return String.valueOf(ajc$this.pin.getSlaveAddress());
    }

    static final /* synthetic */ boolean setValue_aroundBody4(ModbusIOImpl ajc$this, int value, JoinPoint joinPoint) {
        boolean successfulWrite;
        block6: {
            if (!ajc$this.isResolvable()) {
                return false;
            }
            successfulWrite = false;
            if (ajc$this.controllerInterface.isConnected()) {
                try {
                    if (ajc$this.ioType == IO.IOType.DIGITAL) {
                        ajc$this.pin.sendModbusOutputSignalChange(value != 0);
                        successfulWrite = true;
                        break block6;
                    }
                    ajc$this.pin.sendModbusOutputRegisterValue(value);
                    successfulWrite = true;
                }
                catch (Exception exception) {
                    Log.error((String)"Failed to send value change to controller");
                }
            } else {
                Log.error((String)"Controller is not connected");
            }
        }
        return successfulWrite;
    }

    static final /* synthetic */ int getValue_aroundBody6(ModbusIOImpl ajc$this, JoinPoint joinPoint) {
        if (ajc$this.ioType == IO.IOType.DIGITAL) {
            return ajc$this.pin.getValue() == 0 ? 0 : 1;
        }
        return ajc$this.pin.getValue();
    }

    static final /* synthetic */ boolean isResolvable_aroundBody8(ModbusIOImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.namingService.isNameUsed(ModbusSignal.class, ajc$this.getName());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ModbusIOImpl.java", ModbusIOImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getIpAddress", "com.ur.urcap.installation.io.ModbusIOImpl", "", "", "", "java.lang.String"), 28);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSignalAddress", "com.ur.urcap.installation.io.ModbusIOImpl", "", "", "", "java.lang.String"), 33);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setValue", "com.ur.urcap.installation.io.ModbusIOImpl", "int", "value", "", "boolean"), 38);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getValue", "com.ur.urcap.installation.io.ModbusIOImpl", "", "", "", "int"), 65);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isResolvable", "com.ur.urcap.installation.io.ModbusIOImpl", "", "", "", "boolean"), 75);
    }
}

