/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi;

import com.ur.polyscope.urcaps.contributions.URCap;
import com.ur.polyscope.urcaps.contributions.URCapProvider;
import com.ur.swing.BundleClassAuthorizer;
import com.ur.urcap.api.contribution.InstallationNodeService;
import com.ur.urcap.api.contribution.ProgramNodeService;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeService;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeService;
import com.ur.urcap.api.contribution.toolbar.swing.SwingToolbarService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class BundleClassAuthorizerProvider
implements URCapProvider {
    private BundleContext context;
    private BundleClassAuthorizer classAuthorizer;

    public BundleClassAuthorizerProvider(BundleContext context) {
        this.context = context;
    }

    @Inject
    public void setBundleClassAuthorizer(BundleClassAuthorizer authorizer) {
        this.classAuthorizer = authorizer;
    }

    public Collection<URCap> getURCaps() {
        if (this.classAuthorizer != null) {
            try {
                this.classAuthorizer.denyClassesIn(this.context, this.getURCapServiceClasses());
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        return Collections.EMPTY_SET;
    }

    private Set<Class> getURCapServiceClasses() {
        HashSet<Class> classSet = new HashSet<Class>();
        classSet.add(ProgramNodeService.class);
        classSet.add(SwingProgramNodeService.class);
        classSet.add(InstallationNodeService.class);
        classSet.add(SwingInstallationNodeService.class);
        classSet.add(SwingToolbarService.class);
        return classSet;
    }
}

