/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi;

import com.ur.bean.ReflectUtils;
import com.ur.disk.Directories;
import com.ur.injection.Binder;
import com.ur.injection.Builder;
import com.ur.injection.InjectionFactory;
import com.ur.injection.ServicesBinder;
import com.ur.polyscope.core.api.featuretoggle.isolatedosgi.IsolatedOSGiFeatureToggle;
import com.ur.polyscope.io.tool.control.ToolIOControlService;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.urcaps.URCapStartFilter;
import com.ur.polyscope.urcaps.contributions.ContributionSet;
import com.ur.polyscope.urcaps.contributions.URCapProvider;
import com.ur.polyscope.urcaps.contributions.URCapServicesBinder;
import com.ur.polyscope.urcaps.contributions.compatibility.BundleCompatibilityValidator;
import com.ur.polyscope.urcaps.domain.DataModelReader;
import com.ur.polyscope.urcaps.domain.DataModelWriter;
import com.ur.polyscope.urcaps.jointposition.JointPositionUtil;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.FlipManagerProvider;
import com.ur.swing.platform.ActionPanelDefinition;
import com.ur.swing.platform.SetupSite;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.ApplicationAPI;
import com.ur.urcap.api.domain.InstallationAPI;
import com.ur.urcap.api.domain.ProgramAPI;
import com.ur.urcap.api.domain.SystemAPI;
import com.ur.urcap.api.domain.URCapAPI;
import com.ur.urcap.api.domain.URCapAPIFacade;
import com.ur.urcap.api.domain.UserInterfaceAPI;
import com.ur.urcap.api.domain.function.FunctionModel;
import com.ur.urcap.api.domain.io.IOModel;
import com.ur.urcap.api.domain.program.ProgramModel;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.urcap.api.domain.robot.RobotLimits;
import com.ur.urcap.api.domain.robot.RobotModel;
import com.ur.urcap.api.domain.robot.RobotSimulation;
import com.ur.urcap.api.domain.system.SystemSettings;
import com.ur.urcap.api.domain.system.localization.Localization;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.userinteraction.UserInteraction;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidationFactory;
import com.ur.urcap.api.domain.userinteraction.keyboard.KeyboardInputFactory;
import com.ur.urcap.api.domain.value.expression.ExpressionBuilder;
import com.ur.urcap.api.domain.value.jointposition.JointPositionFactory;
import com.ur.urcap.api.domain.variable.VariableModel;
import com.ur.urcap.contribution.DataModelXMLConversionStrategy;
import com.ur.urcap.contribution.SubTreeActions;
import com.ur.urcap.contribution.ViewAPIProviderImpl;
import com.ur.urcap.contribution.program.DataModelXMLConversionStrategyImpl;
import com.ur.urcap.contribution.program.ProgramAPIProviderImpl;
import com.ur.urcap.contribution.program.ProgramDebuggingSupportImpl;
import com.ur.urcap.contribution.program.ProgramDebuggingSupportProviderImpl;
import com.ur.urcap.contribution.program.URCapProgramModule;
import com.ur.urcap.domain.expression.ExpressionAnalyzer;
import com.ur.urcap.domain.expression.ExpressionAnalyzerImpl;
import com.ur.urcap.domain.expression.ExpressionBuilderImpl;
import com.ur.urcap.domain.function.FunctionModelImpl;
import com.ur.urcap.domain.program.PalletNodeFactory;
import com.ur.urcap.domain.program.ProgramModelImpl;
import com.ur.urcap.domain.program.ProgramNodeFactories;
import com.ur.urcap.domain.program.ProgramNodeFactoryImpl;
import com.ur.urcap.domain.program.ProgramNodeWrapperFactory;
import com.ur.urcap.domain.program.ProgramNodeWrapperFactoryImpl;
import com.ur.urcap.domain.program.RealNodeFactory;
import com.ur.urcap.domain.program.RealNodeFactoryImpl;
import com.ur.urcap.domain.program.ScrewdrivingNodeFactory;
import com.ur.urcap.domain.robot.RobotSimulationImpl;
import com.ur.urcap.domain.undoredomanager.UndoRedoManagerImpl;
import com.ur.urcap.domain.userinteraction.KeyboardInputFactoryImpl;
import com.ur.urcap.domain.validation.ValidatorFactoryImpl;
import com.ur.urcap.domain.variable.VariableFactoryImpl;
import com.ur.urcap.domain.variable.VariableModelImpl;
import com.ur.urcap.installation.io.IOModelImpl;
import com.ur.urcap.installation.robot.RobotLimitsImpl;
import com.ur.urcap.installation.robot.RobotModelImpl;
import com.ur.urcap.osgi.BundleClassAuthorizerProvider;
import com.ur.urcap.osgi.FillerDataModelWriter;
import com.ur.urcap.osgi.ProgramURCapProvider;
import com.ur.urcap.osgi.ProxyServicesBinder;
import com.ur.urcap.osgi.URCapErrorLogger;
import com.ur.urcap.osgi.URCapFailureHandler;
import com.ur.urcap.osgi.URCapInstallDirProvider;
import com.ur.urcap.osgi.URCapInvalidHandler;
import com.ur.urcap.osgi.URCapProblemHandler;
import com.ur.urcap.osgi.UpdateProgramTreeOnDaemonStateChange;
import com.ur.urcap.osgi.bundle.BundleFileInfo;
import com.ur.urcap.osgi.bundle.BundleUtility;
import com.ur.urcap.osgi.error.URCapError;
import com.ur.urcap.osgi.infrastructure.ManageURCapsView;
import com.ur.urcap.osgi.infrastructure.ManageURCapsViewImpl;
import com.ur.urcap.osgi.infrastructure.ThirdPartyBundleManager;
import com.ur.urcap.osgi.infrastructure.ThirdPartyLicenseManager;
import com.ur.urcap.osgi.infrastructure.URCapSetupActionPanel;
import com.ur.urcap.osgi.infrastructure.URCapsService;
import com.ur.urcap.osgi.infrastructure.URCapsServiceImpl;
import com.ur.urcap.osgi.infrastructure.UnremovableBundleManager;
import com.ur.urcap.osgi.infrastructure.helper.URCapHelper;
import com.ur.urcap.systemsettings.LocalizationImpl;
import com.ur.urcap.systemsettings.SystemSettingsImpl;
import com.ur.urcap.ui.main.impl.GuiReadyEvaluator;
import com.ur.urcap.ui.main.impl.URCapAPIImpl;
import com.ur.urcap.ui.main.impl.URGuiReadyEvaluator;
import com.ur.urcap.ui.main.impl.UserInteractionImpl;
import com.ur.util.logging.Log;
import com.ur.view.polyscope.module.BindingModule;
import com.ur.view.polyscope.module.programs.ProgramContributionProvider;
import com.ur.view.polyscope.module.programs.ProgramModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class BundleServicesBinder
implements BindingModule,
URCapErrorLogger {
    public static final String BUNDLE_CATEGORY = "Bundle-Category";
    private static final String URCAPS_DIRECTORY = "urcap.directory";
    private static final Logger LOG = LogFactory.createLogger(BundleServicesBinder.class);
    private final URCapProgramModule programModule;
    private final BundleContext bundleContext;
    Set<URCapStartFilter> urCapStartFilters = new HashSet<URCapStartFilter>();
    private final ServicesBinder[] binders;
    private final ThirdPartyLicenseManager thirdPartyLicenseManager;
    private final UnremovableBundleManager unremovableBundleManager;
    private final ThirdPartyBundleManager thirdPartyBundleManager;
    private final URCapFailureHandler urCapFailureHandler;
    private final URCapInvalidHandler urCapInvalidHandler;
    private final URCapInstallDirProvider urCapInstallDirProvider;
    private final Map<Bundle, URCapError> notCompatibleBundles = new LinkedHashMap<Bundle, URCapError>();
    private final Map<BundleFileInfo, URCapError> notStartedBundles = new LinkedHashMap<BundleFileInfo, URCapError>();
    private final URCapHelper urCapHelper;
    private BundleCompatibilityValidator bundleCompatibilityValidator;

    static {
        System.setProperty(URCAPS_DIRECTORY, String.valueOf(Directories.urcontrol().getPath()) + File.separator + ".." + File.separator + ".urcaps");
    }

    public BundleServicesBinder(URCapProgramModule programModule, BundleContext bundleContext, URCapProblemHandler urCapProblemHandler, URCapHelper urCapHelper, ServicesBinder ... binders) {
        this.thirdPartyLicenseManager = new ThirdPartyLicenseManager();
        this.unremovableBundleManager = new UnremovableBundleManager();
        this.thirdPartyBundleManager = new ThirdPartyBundleManager(this.thirdPartyLicenseManager, this.unremovableBundleManager);
        this.programModule = programModule;
        this.bundleContext = bundleContext;
        this.urCapFailureHandler = urCapProblemHandler.getFailureHandler();
        this.urCapInvalidHandler = urCapProblemHandler.getInvalidHandler();
        this.urCapInstallDirProvider = urCapProblemHandler.getInstallDirProvider();
        this.binders = binders;
        this.urCapHelper = urCapHelper;
        URCapFailureHandler.addLogger(this);
        URCapInvalidHandler.addLogger(this);
    }

    public Builder bindService(Builder parentBuilder) {
        ArrayList<ServicesBinder> allBinders = new ArrayList<ServicesBinder>();
        InjectionFactory.ModuleAggregator aggregator = InjectionFactory.createModuleAggregator((Builder)parentBuilder);
        try {
            for (ServiceReference ref : this.bundleContext.getServiceReferences(URCapServicesBinder.class, null)) {
                ProxyServicesBinder binder = new ProxyServicesBinder((URCapServicesBinder)this.bundleContext.getService(ref));
                aggregator.add((ServicesBinder)binder);
                allBinders.add(binder);
            }
        }
        catch (Exception exception) {
            LOG.error("Unable to load contributed URCapServicesBinders", new Object[0]);
        }
        ServicesBinder[] servicesBinderArray = this.binders;
        int binder = this.binders.length;
        int n = 0;
        while (n < binder) {
            ServicesBinder each = servicesBinderArray[n];
            aggregator.add(each);
            allBinders.add(each);
            ++n;
        }
        ServicesBinder serviceBinder = this.createServiceBinder();
        aggregator.add(serviceBinder);
        allBinders.add(serviceBinder);
        Builder builder = aggregator.createBuilder();
        try {
            for (URCapProvider each : builder.getExtensions(URCapProvider.class)) {
                LOG.info("Loading URCapProvider %s", new Object[]{each.getClass()});
                ((ContributionSet)builder.get(ContributionSet.class)).addProvider(each);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to load Installation Provider", (Throwable)e);
        }
        for (ServicesBinder each : allBinders) {
            each.load(builder);
        }
        URCapSetupActionPanel urCapSetupActionPanel = (URCapSetupActionPanel)((Object)builder.get(URCapSetupActionPanel.class));
        urCapSetupActionPanel.setBundleContext(this.bundleContext);
        ((SetupSite)builder.get(SetupSite.class)).addActionForPanel((ActionPanelDefinition)urCapSetupActionPanel);
        ReflectUtils.setFieldOnClass(URCapAPIFacade.class, (String)"api", (Object)builder.get(URCapAPI.class));
        ReflectUtils.setFieldOnClass(URCapAPIFacade.class, (String)"systemAPI", (Object)builder.get(SystemAPI.class));
        ((ProgramContributionProvider)parentBuilder.get(ProgramContributionProvider.class)).registerModule((ProgramModule)this.programModule);
        builder.get(ToolIOControlService.class);
        this.urCapStartFilters = parentBuilder.getExtensions(URCapStartFilter.class);
        this.bundleCompatibilityValidator = (BundleCompatibilityValidator)builder.get(BundleCompatibilityValidator.class);
        this.notCompatibleBundles.clear();
        List<Bundle> bundlesToStart = this.startURCapBundles(this.bundleContext);
        if (!IsolatedOSGiFeatureToggle.isEnabled()) {
            ArrayList<Bundle> allThirdPartyBundles = this.urCapHelper.getThirdPartyBundles(this.bundleContext);
            this.thirdPartyBundleManager.setBundles(allThirdPartyBundles, bundlesToStart, this.notCompatibleBundles, this.notStartedBundles);
        }
        return builder;
    }

    private ServicesBinder createServiceBinder() {
        return new ServicesBinder(){

            public void bind(Binder binder) {
                binder.bindClass(PalletNodeFactory.class, PalletNodeFactory.URCapPalletNodeFactory.class);
                binder.bindClass(ScrewdrivingNodeFactory.class, ScrewdrivingNodeFactory.URCapScrewdrivingNodeFactory.class);
                binder.bindClass(ManageURCapsView.class, ManageURCapsViewImpl.class);
                binder.bindToExtensionPoint(DataModelReader.class, VariableFactoryImpl.class);
                binder.bindToExtensionPoint(DataModelWriter.class, (Object)new FillerDataModelWriter());
                binder.bindInstance(ProgramModule.class, (Object)BundleServicesBinder.this.programModule);
                binder.bindInstance(ThirdPartyBundleManager.class, (Object)BundleServicesBinder.this.thirdPartyBundleManager);
                binder.bindInstance(ThirdPartyLicenseManager.class, (Object)BundleServicesBinder.this.thirdPartyLicenseManager);
                binder.bindInstance(UnremovableBundleManager.class, (Object)BundleServicesBinder.this.unremovableBundleManager);
                binder.bindClass(URCapsService.class, URCapsServiceImpl.class);
                binder.bindClass(FunctionModel.class, FunctionModelImpl.class);
                binder.bindClass(ProgramModel.class, ProgramModelImpl.class);
                binder.bindClass(SubTreeActions.class, ProgramModelImpl.class);
                binder.bindClass(VariableModel.class, VariableModelImpl.class);
                binder.bindClass(ProgramNodeFactory.class, ProgramNodeFactoryImpl.class);
                binder.bindClass(ProgramNodeFactories.class, ProgramNodeFactoryImpl.class);
                binder.bindClass(RealNodeFactory.class, RealNodeFactoryImpl.class);
                binder.bindClass(ProgramNodeWrapperFactory.class, ProgramNodeWrapperFactoryImpl.class);
                binder.bindClass(IOModel.class, IOModelImpl.class);
                binder.bindClass(RobotModel.class, RobotModelImpl.class);
                binder.bindClass(RobotLimits.class, RobotLimitsImpl.class);
                binder.bindClass(URCapAPI.class, URCapAPIImpl.class);
                binder.bindClass(ApplicationAPI.class, URCapAPIImpl.class);
                binder.bindClass(InstallationAPI.class, URCapAPIImpl.class);
                binder.bindClass(ProgramAPI.class, URCapAPIImpl.class);
                binder.bindClass(SystemAPI.class, URCapAPIImpl.class);
                binder.bindClass(UserInterfaceAPI.class, URCapAPIImpl.class);
                binder.bindClass(ProgramAPIProvider.class, ProgramAPIProviderImpl.class);
                binder.bindClass(SystemSettings.class, SystemSettingsImpl.class);
                binder.bindClass(Localization.class, LocalizationImpl.class);
                binder.bindClass(ExpressionBuilder.class, ExpressionBuilderImpl.class);
                binder.bindClass(ExpressionAnalyzer.class, ExpressionAnalyzerImpl.class);
                binder.bindInstance(JointPositionFactory.class, (Object)JointPositionUtil.getFactory());
                binder.bindClass(UserInteraction.class, UserInteractionImpl.class);
                binder.bindClass(InputValidationFactory.class, ValidatorFactoryImpl.class);
                binder.bindClass(KeyboardInputFactory.class, KeyboardInputFactoryImpl.class);
                binder.bindClass(DataModelXMLConversionStrategy.class, DataModelXMLConversionStrategyImpl.class);
                binder.bindProvider(FlipManager.class, (Provider)new FlipManagerProvider(){

                    public FlipManager get() {
                        CardPanel currentCard = CardPanel.getCurrentPanel();
                        FlipManager fm = null;
                        if (currentCard != null) {
                            fm = currentCard.getFlipManager();
                        }
                        return fm;
                    }
                });
                binder.bindClass(UndoRedoManager.class, UndoRedoManagerImpl.class);
                binder.bindClass(ViewAPIProvider.class, ViewAPIProviderImpl.class);
                binder.bindClass(GuiReadyEvaluator.class, URGuiReadyEvaluator.class);
                binder.bindClass(RobotSimulation.class, RobotSimulationImpl.class);
                binder.bindToExtensionPoint(URCapProvider.class, (Object)new ProgramURCapProvider(BundleServicesBinder.this.bundleContext));
                binder.bindToExtensionPoint(URCapProvider.class, (Object)new BundleClassAuthorizerProvider(BundleServicesBinder.this.bundleContext));
                binder.bindProvider(ProgramDebuggingSupportImpl.class, ProgramDebuggingSupportProviderImpl.class);
            }

            public void load(Builder builder) {
                builder.get(UpdateProgramTreeOnDaemonStateChange.class);
            }
        };
    }

    List<Bundle> startURCapBundles(BundleContext context) {
        if (context == null) {
            return new ArrayList<Bundle>();
        }
        List<Bundle> bundlesToStart = this.urCapHelper.getBundlesToStart(context, this.urCapStartFilters.toArray(new URCapStartFilter[0]), this.bundleCompatibilityValidator);
        for (Bundle bundle : bundlesToStart) {
            try {
                Log.info((String)("Starting URCap: " + bundle.getSymbolicName()));
                bundle.start(1);
            }
            catch (BundleException e) {
                URCapFailureHandler.FailureType failureType = this.urCapFailureHandler.logFailure(bundle, (Exception)((Object)e));
                if (failureType == URCapFailureHandler.FailureType.UNKNOWN) {
                    this.log("Error starting bundle.", e);
                    continue;
                }
                this.urCapHelper.getFilteredBundlesNotStarting().add(bundle);
            }
        }
        try {
            ArrayList<Bundle> knownBundles = new ArrayList<Bundle>(bundlesToStart);
            knownBundles.addAll(this.urCapHelper.getFilteredBundlesNotStarting());
            knownBundles.addAll(this.notCompatibleBundles.keySet());
            this.processUnknownJars(this.urCapHelper.getURCapPaths(knownBundles), knownBundles, this.urCapInstallDirProvider.getInstallDir());
        }
        catch (Exception e) {
            Log.error((String)"Error processing URCaps", (Throwable)e);
        }
        return bundlesToStart;
    }

    protected void log(String message, BundleException e) {
        Log.error((String)message, (Throwable)e);
    }

    private void processUnknownJars(HashSet<String> knownURCaps, List<Bundle> bundles, File dir) throws IOException {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        Collection files = FileUtils.listFiles((File)dir, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".jar");
            }

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        }, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return "zip".equalsIgnoreCase(file.getName());
            }

            public boolean accept(File dir, String name) {
                return "zip".equalsIgnoreCase(name);
            }
        });
        for (File file : files) {
            if (!file.isFile()) continue;
            if (BundleUtility.hasManifestFile(file) && BundleUtility.isThirdPartyURCap(file)) {
                this.logErrorIfNotStarted(file, bundles);
                continue;
            }
            if (knownURCaps.contains(file.getCanonicalPath())) continue;
            this.urCapInvalidHandler.logInvalidURCap(file);
        }
    }

    private void logErrorIfNotStarted(File file, List<Bundle> bundles) {
        boolean bundleStarted = false;
        for (Bundle bundle : bundles) {
            if (!BundleUtility.isSameFile(file, bundle)) continue;
            bundleStarted = true;
            break;
        }
        if (!bundleStarted) {
            this.urCapInvalidHandler.logInvalidURCap(file);
        }
    }

    @Override
    public void logError(URCapError error) {
        BundleFileInfo bundleFileInfo;
        Bundle bundle = error.getBundle();
        if (bundle != null) {
            this.notCompatibleBundles.put(bundle, error);
        }
        if ((bundleFileInfo = error.getBundleFileInfo()) != null) {
            this.notStartedBundles.put(bundleFileInfo, error);
        }
    }
}

