/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi;

import com.ur.lang.StringUtils;
import com.ur.urcap.osgi.URCapErrorLogger;
import com.ur.urcap.osgi.error.URCapError;
import com.ur.util.logging.Log;

public class ConsoleLogger
implements URCapErrorLogger {
    int indentationLength = "13:05:43.074 ERROR - ".length();

    @Override
    public void logError(URCapError error) {
        if (StringUtils.isNullOrEmpty((String)error.getStackTrace())) {
            Log.error((String)error.getFullMessage());
        } else {
            this.logErrorWithStackTrace(error.getFullMessage(), error.getStackTrace());
        }
    }

    public void logErrorWithStackTrace(String title, String htmlStacktrace) {
        Log.error((String)String.format("%s%s%s", title, this.getNewLineWithPadding(), this.stripHtml(this.removeLastNewLine(htmlStacktrace))));
    }

    private String removeLastNewLine(String s) {
        return s.endsWith("<br/>") ? s.substring(0, s.length() - "<br/>".length()) : s;
    }

    private String stripHtml(String s) {
        return s.replace("<br/>", this.getNewLineWithPadding()).replace("&nbsp;", " ");
    }

    private String getNewLineWithPadding() {
        return String.format("%n%s", this.getPadding());
    }

    private String getPadding() {
        String paddingFormat = String.format("%%1$%ds", this.indentationLength);
        return String.format(paddingFormat, " ");
    }
}

