/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi;

import com.ur.polyscope.core.api.osgi.FrameworkAdapter;
import com.ur.polyscope.urcaps.BundleUtils;
import com.ur.polyscope.urcaps.ConsoleLoggerExceptionHandler;
import com.ur.polyscope.urcaps.ExceptionHandling;
import com.ur.polyscope.urcaps.URCapZipInfo;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.urcap.contribution.ConsoleLoggerExceptionHelper;
import com.ur.urcap.osgi.ConsoleLogger;
import com.ur.util.logging.Log;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

@Singleton
public class ConsoleLoggerExceptionHelperImpl
implements ConsoleLoggerExceptionHandler,
ConsoleLoggerExceptionHelper {
    private final ExceptionHandling exceptionHandling;
    private ConsoleLogger consoleLogger = new ConsoleLogger();
    private StackTraceElement unknownExitPoint = new StackTraceElement("", "", "", -1);
    @Inject
    private BundleUtils bundleUtils;
    @Inject
    private FrameworkAdapter frameworkAdapter;

    @Inject
    public ConsoleLoggerExceptionHelperImpl(ExceptionHandling exceptionHandling) {
        this.exceptionHandling = exceptionHandling;
    }

    @Override
    public void logToConsole(Throwable e, Class aClass, StackTraceElement exitPoint) {
        if (e instanceof ProxiedException) {
            this.logToConsole((ProxiedException)e);
        } else {
            if (exitPoint == null) {
                exitPoint = this.unknownExitPoint;
            }
            this.doLog(e, aClass, exitPoint);
        }
    }

    private void doLog(Throwable e, Class aClass, StackTraceElement exitPoint) {
        this.consoleLogger.logErrorWithStackTrace(String.format("Unhandled exception in URCap '%s'", this.getURCapName(aClass)), this.getFilteredStackTrace(e, exitPoint));
    }

    @Override
    public void logToConsole(Throwable e, Class aClass) {
        this.logToConsole(e, aClass, this.unknownExitPoint);
    }

    private void logToConsole(ProxiedException e) {
        this.doLog((Throwable)e, e.getThrowingClass(), this.findCatchingMethod(e));
    }

    private String getURCapName(Class aClass) {
        Bundle bundle = this.frameworkAdapter.getBundle(aClass);
        if (BundleUtils.isZipInstalledBundle((Bundle)bundle)) {
            URCapZipInfo zipInfo = this.bundleUtils.getURCapZipInfo(bundle);
            if (zipInfo != null) {
                return zipInfo.getName();
            }
            Log.error((String)"Unable to obtain URCap identification data");
        }
        return (String)bundle.getHeaders().get("Bundle-Name");
    }

    private String getFilteredStackTrace(Throwable e, StackTraceElement exitPoint) {
        Throwable throwable = e;
        if (e instanceof BundleException && ((BundleException)e).getNestedException() != null) {
            throwable = ((BundleException)e).getNestedException();
        }
        return this.exceptionHandling.getStackTraceOutsidePolyScope(throwable, exitPoint);
    }

    @Override
    public StackTraceElement findCatchingMethod(Throwable e, String fullyQualifiedClassName, String methodName) {
        StackTraceElement[] stackTrace;
        StackTraceElement[] stackTraceElementArray = stackTrace = e.getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            if (stackTraceElement.getClassName().equals(fullyQualifiedClassName) && stackTraceElement.getMethodName().equals(methodName)) {
                return stackTraceElement;
            }
            ++n2;
        }
        return null;
    }

    public StackTraceElement findCatchingMethod(ProxiedException e) {
        return this.findCatchingMethod((Throwable)e, e.getCatchingClassName(), e.getCatchingMethodName());
    }
}

