/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi;

import com.ur.i18n.TextResource;
import com.ur.lang.StringUtils;
import com.ur.polyscope.urcaps.BundleUtils;
import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.urcap.contribution.WaitingOnMainUI;
import com.ur.urcap.html.util.HTMLBuilder;
import com.ur.urcap.osgi.URCapErrorLogger;
import com.ur.urcap.osgi.error.URCapError;
import com.ur.util.Waiting;
import com.ur.view.DialogWithName;
import gui.tools.DialogCreator;
import gui.tools.dialogs.MessageDialogPanel;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.osgi.framework.Bundle;

public class DialogLogger
implements URCapErrorLogger {
    private final DialogCreator dialogCreator;
    private final BundleUtils bundleUtils;
    private final WaitingOnMainUI waitingOnMainUI;
    private final TextResource textResource;

    @Inject
    public DialogLogger(DialogCreator dialogCreator, BundleUtils bundleUtils, WaitingOnMainUI waitingOnMainUI, TextResource textResource) {
        this.dialogCreator = dialogCreator;
        this.bundleUtils = bundleUtils;
        this.waitingOnMainUI = waitingOnMainUI;
        this.textResource = textResource;
    }

    @Override
    public void logError(final URCapError error) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                DialogLogger.this.waitUntilReady();
                SwingUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DialogLogger.this.showDialog(error);
                    }
                });
            }
        }).start();
    }

    private void waitUntilReady() {
        Waiting.until((Waiting.ItHappens)this.waitingOnMainUI, (int)2, (TimeUnit)TimeUnit.MINUTES);
    }

    void showDialog(URCapError error) {
        Map<String, String> urCapInfoMap = this.getURCapInfo(error);
        String title = error.getLocalizedTitle();
        String message = error.getLocalizedMessage();
        String suggestion = error.getLocalizedSuggestion();
        String advancedMessage = error.getLocalizedAdvancedMessage();
        HTMLBuilder html = new HTMLBuilder();
        html.start("p");
        html.text(message);
        html.end("p");
        if (suggestion != null && !suggestion.isEmpty()) {
            html.br();
            html.start("p");
            html.b(suggestion);
            html.end("p");
        }
        String messageText = html.toString();
        MessageDialogPanel panel = MessageDialogPanel.createWarningDialog((String)messageText, urCapInfoMap, (String)advancedMessage, (String)"", null, (String)this.textResource.AdvancedDetails());
        ErrorMessage errorMessage = new ErrorMessage(DialogWithName.RUNTIME_EXCEPTION.getName(), title, "", "");
        errorMessage.setId(error.getMessage().hashCode());
        this.dialogCreator.showErrorMessageWithCustomPanel((DialogMessage)errorMessage, (URDialogPanel)panel, null);
    }

    private Map<String, String> getURCapInfo(URCapError error) {
        Bundle bundle = error.getBundle();
        Dictionary<String, String> urcapInfo = error.getUrcapInfo();
        Map<String, String> urCapInfoMap = bundle != null ? this.bundleUtils.buildMetaInfoMap(bundle, EnumSet.of(BundleUtils.BundleMetaField.NAME, BundleUtils.BundleMetaField.VERSION, BundleUtils.BundleMetaField.DEVELOPER, BundleUtils.BundleMetaField.CONTACT_INFO)) : (urcapInfo != null && !urcapInfo.isEmpty() ? this.createInfoMapFromDictionary(urcapInfo) : new HashMap<String, String>());
        return urCapInfoMap;
    }

    private Map<String, String> createInfoMapFromDictionary(Dictionary<String, String> urcapInfo) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(String.valueOf(this.textResource.urcapName()) + ":", StringUtils.ensureEmptyString((String)urcapInfo.get("Bundle-Name")));
        map.put(String.valueOf(this.textResource.urcapVersion()) + ":", StringUtils.ensureEmptyString((String)urcapInfo.get("Bundle-Version")));
        map.put(String.valueOf(this.textResource.Developer()) + ":", StringUtils.ensureEmptyString((String)urcapInfo.get("Bundle-Vendor")));
        map.put(String.valueOf(this.textResource.urcapContactinfo()) + ":", StringUtils.ensureEmptyString((String)urcapInfo.get("Bundle-ContactAddress")));
        return map;
    }
}

