/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi;

import com.ur.polyscope.core.api.osgi.FrameworkAdapter;
import com.ur.polyscope.persistence.TypedOptionsSection;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.urcaps.contributions.ContributionSet;
import com.ur.polyscope.urcaps.contributions.URCap;
import com.ur.polyscope.urcaps.contributions.URCapInformation;
import com.ur.urcap.contribution.installation.CreationContextHolder;
import com.ur.urcap.contribution.installation.MissingURCapInstallationNode;
import com.ur.urcap.contribution.installation.URCapInstallation;
import com.ur.urcap.contribution.installation.URCapInstallationFactory;
import com.ur.urcap.contribution.installation.URCapInstallationProvider;
import com.ur.urcap.contribution.program.MissingProgramContribution;
import com.ur.urcap.contribution.program.ProgramContribution;
import com.ur.urcap.contribution.program.ProgramNodeFactory;
import com.ur.urcap.contribution.program.URCapProgram;
import com.ur.urcap.contribution.program.URCapProgramProvider;
import com.ur.urcap.domain.function.URCapInformationProvider;
import com.ur.util.CollectionUtils;
import com.ur.util.Predicate;
import com.ur.view.polyscope.module.programs.ProgramModule;
import gui.polyscope.contribution.Contribution;
import gui.polyscope.contribution.TypedProgramNodeModel;
import gui.program.ContributableProgramNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.osgi.framework.Bundle;

public class OSGiURCapBundleProvider
implements URCapProgramProvider,
URCapInstallationProvider,
URCapInformationProvider {
    private ContributionSet urcapContributions;
    private final HashMap<String, ProgramModule.ContributableProgramNodeFactory> contributableProgramNodeFactories = new HashMap();
    private Provider<MissingProgramContribution> missingProgramContributionProvider;
    private URCapInstallationFactory urcapInstallationFactory;
    @Inject
    private FrameworkAdapter frameworkAdapter;

    public OSGiURCapBundleProvider() {
        this.urcapContributions = new ContributionSet();
    }

    @Inject
    public void setURCapProviders(ContributionSet contributionSet) {
        this.urcapContributions = contributionSet;
    }

    @Inject
    public void setURCapInstallationFactory(URCapInstallationFactory urcapInstallationFactory) {
        this.urcapInstallationFactory = urcapInstallationFactory;
    }

    @Inject
    public void setMissingProgramContributionProvider(Provider<MissingProgramContribution> missingProgramContributionProvider) {
        this.missingProgramContributionProvider = missingProgramContributionProvider;
    }

    @Override
    public List<URCapInstallation> getInstallationContributions() {
        ArrayList<URCapInstallation> installations = new ArrayList<URCapInstallation>();
        for (URCap each : CollectionUtils.filter((Iterable)this.urcapContributions.getContributions(), (Predicate)new InstallationContributions())) {
            installations.add((URCapInstallation)each);
        }
        return installations;
    }

    @Override
    public List<URCapProgram> getProgramContributions() {
        this.createContributableProgramNodeFactories();
        ArrayList<URCapProgram> urCapPrograms = new ArrayList<URCapProgram>();
        for (URCap each : CollectionUtils.filter((Iterable)this.urcapContributions.getContributions(), (Predicate)new ProgramFactoryContributions())) {
            urCapPrograms.add((URCapProgram)each);
        }
        return urCapPrograms;
    }

    public void createContributableProgramNodeFactories() {
        if (!this.contributableProgramNodeFactories.isEmpty()) {
            return;
        }
        this.contributableProgramNodeFactories.clear();
        Collection contributions = this.urcapContributions.getContributions();
        if (contributions.isEmpty()) {
            return;
        }
        List filter = CollectionUtils.filter((Iterable)contributions, (Predicate)new ProgramFactoryContributions());
        for (URCap each : filter) {
            Collection<ProgramNodeFactory> factories;
            ProgramContribution contribution = ((URCapProgram)each).getProgramContribution();
            if (contribution == null || (factories = contribution.getProgramNodeFactories()) == null) continue;
            for (ProgramNodeFactory factory : factories) {
                this.contributableProgramNodeFactories.put(factory.getId(), factory);
            }
        }
    }

    @Override
    public URCapInformation getURCapInformation(Class clazz) {
        Bundle bundle = this.frameworkAdapter.getBundle(clazz);
        return OSGiURCapBundleProvider.createURCapInformation(bundle);
    }

    @Override
    public URCapInstallation createMissingUrcap(String id, URCapInformation urCapInformation, TypedOptionsSection section, MissingURCapInstallationNode.Callback callback) {
        MissingURCapInstallationNode urCapInstallationNode = this.urcapInstallationFactory.createMissingURCapInstallationNode();
        urCapInstallationNode.setId(id);
        urCapInstallationNode.setURCapInformation(urCapInformation);
        urCapInstallationNode.setInstallationModel(section, CreationContextHolder.createLoad());
        urCapInstallationNode.setCallback(callback);
        return urCapInstallationNode;
    }

    @Override
    public ContributableProgramNode createMissingProgramContribution(TypedProgramNodeModel model, String nodeId) {
        Contribution contribution = (Contribution)this.missingProgramContributionProvider.get();
        contribution.setId(nodeId);
        contribution.setProgramNodeModel(model);
        ContributableProgramNode node = new ContributableProgramNode(contribution);
        model.setTarget((AbstractProgramNode)node);
        return node;
    }

    @Override
    public ProgramModule.ContributableProgramNodeFactory getContributableProgramNodeFactory(String nodeId) {
        this.createContributableProgramNodeFactories();
        return this.contributableProgramNodeFactories.get(nodeId);
    }

    @Override
    public Collection<ProgramModule.ContributableProgramNodeFactory> getContributableProgramNodeFactories() {
        this.createContributableProgramNodeFactories();
        return this.contributableProgramNodeFactories.values();
    }

    public static URCapInformation createURCapInformation(Bundle bundle) {
        Dictionary headers = null;
        if (bundle != null) {
            headers = bundle.getHeaders();
        }
        return new URCapInformation(OSGiURCapBundleProvider.dictionary2map(headers));
    }

    private static Map<String, String> dictionary2map(Dictionary<String, String> dictionary) {
        if (dictionary == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result.put(key, dictionary.get(key));
        }
        return result;
    }

    private static class InstallationContributions
    implements Predicate<URCap> {
        private InstallationContributions() {
        }

        public boolean test(URCap urcap) {
            return urcap instanceof URCapInstallation && ((URCapInstallation)urcap).hasInstallationContribution();
        }
    }

    private static class ProgramFactoryContributions
    implements Predicate<URCap> {
        private ProgramFactoryContributions() {
        }

        public boolean test(URCap urcap) {
            return urcap instanceof URCapProgram;
        }
    }
}

