/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi;

import com.ur.polyscope.core.api.osgi.FrameworkAdapter;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.pallet.PalletContribution;
import com.ur.polyscope.pallet.PalletFeatureService;
import com.ur.polyscope.pallet.PalletMotionService;
import com.ur.polyscope.pallet.PalletNamingService;
import com.ur.polyscope.urcaps.contributions.URCap;
import com.ur.polyscope.urcaps.contributions.URCapInformation;
import com.ur.polyscope.urcaps.contributions.URCapProvider;
import com.ur.polyscope.urcaps.device.URCapServiceProvider;
import com.ur.polyscope.urcaps.nodeservices.ProxiedService;
import com.ur.polyscope.urcaps.nodeservices.URCapClassResolver;
import com.ur.urcap.api.contribution.ProgramNodeService;
import com.ur.urcap.api.contribution.URCapProgramNodeService;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeService;
import com.ur.urcap.api.domain.URCapInfo;
import com.ur.urcap.contribution.program.URCapProgramNode;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ProgramURCapProvider
implements URCapProvider {
    private static final Logger LOGGER = LogFactory.createLogger(ProgramURCapProvider.class);
    private BundleContext context;
    private Provider<URCapProgramNode> urCapProgramNodeProvider;
    private PalletMotionService palletMotionService;
    private PalletNamingService palletNamingService;
    private URCapServiceProvider urCapServiceProvider;
    private PalletFeatureService palletFeatureService;
    @Inject
    private FrameworkAdapter frameworkAdapter;

    public ProgramURCapProvider(BundleContext context) {
        this.context = context;
    }

    @Inject
    public void setURCapServiceProvider(URCapServiceProvider urCapServiceProvider) {
        this.urCapServiceProvider = urCapServiceProvider;
    }

    @Inject
    public void setPalletMotionService(PalletMotionService palletMotionService) {
        this.palletMotionService = palletMotionService;
    }

    @Inject
    public void setPalletNamingService(PalletNamingService palletNamingService) {
        this.palletNamingService = palletNamingService;
    }

    @Inject
    public void setPalletFeatureService(PalletFeatureService palletFeatureService) {
        this.palletFeatureService = palletFeatureService;
    }

    @Inject
    public void setURCapProgramNodeProvider(Provider<URCapProgramNode> urCapProgramNodeProvider) {
        this.urCapProgramNodeProvider = urCapProgramNodeProvider;
    }

    public Collection<URCap> getURCaps() {
        HashSet<URCap> result = new HashSet<URCap>();
        try {
            this.updateProgramNodeFactories(result, this.context);
        }
        catch (InvalidSyntaxException e) {
            LOGGER.error("Failed to bind ProgramNode Contributions", (Throwable)e);
        }
        return result;
    }

    private static URCapInformation createURCapInformation(FrameworkAdapter frameworkAdapter, URCapProgramNodeService service) {
        Class serviceClass = URCapClassResolver.getURCapClass((URCapProgramNodeService)service);
        Bundle bundle = frameworkAdapter.getBundle(serviceClass);
        return ProgramURCapProvider.createURCapInformation(bundle);
    }

    private URCapProgramNode createURCapProgramNode(String id, ProgramNodeService service, URCapInformation urCapInfo) {
        URCapProgramNode urCapProgramNode = (URCapProgramNode)this.urCapProgramNodeProvider.get();
        urCapProgramNode.setId(id);
        urCapProgramNode.setProgramService(service);
        urCapProgramNode.setURCapInformation(urCapInfo);
        return urCapProgramNode;
    }

    private URCapProgramNode createURCapProgramNode(String id, SwingProgramNodeService service, URCapInformation urCapInfo) {
        URCapProgramNode urCapProgramNode = (URCapProgramNode)this.urCapProgramNodeProvider.get();
        urCapProgramNode.setId(id);
        urCapProgramNode.setSwingProgramService(service);
        urCapProgramNode.setURCapInformation(urCapInfo);
        return urCapProgramNode;
    }

    private void updateProgramNodeFactories(Set<URCap> contributions, BundleContext context) throws InvalidSyntaxException {
        ProgramNodeService service;
        for (ServiceReference ref : context.getServiceReferences(ProgramNodeService.class, null)) {
            service = (ProgramNodeService)context.getService(ref);
            URCapInformation urCapInformation = ProgramURCapProvider.createURCapInformation(this.frameworkAdapter, (URCapProgramNodeService)service);
            this.urCapServiceProvider.addProgramNodeService((URCapProgramNodeService)service, (URCapInfo)urCapInformation);
            URCapProgramNode urCapProgramNode = this.createURCapProgramNode(ref.getBundle().getSymbolicName(), service, urCapInformation);
            contributions.add(urCapProgramNode);
        }
        for (ServiceReference ref : context.getServiceReferences(SwingProgramNodeService.class, null)) {
            service = (SwingProgramNodeService)context.getService(ref);
            if (service instanceof PalletContribution) {
                PalletContribution contribution = (PalletContribution)service;
                contribution.setPalletMotionService(this.palletMotionService);
                contribution.setPalletNamingService(this.palletNamingService);
                contribution.setPalletFeatureService(this.palletFeatureService);
            }
            String id = service instanceof ProxiedService ? ((ProxiedService)service).getProxiedId() : ref.getBundle().getSymbolicName();
            URCapInformation urCapInformation = ProgramURCapProvider.createURCapInformation(this.frameworkAdapter, (URCapProgramNodeService)service);
            this.urCapServiceProvider.addProgramNodeService((URCapProgramNodeService)service, (URCapInfo)urCapInformation);
            URCapProgramNode urCapProgramNode = this.createURCapProgramNode(id, (SwingProgramNodeService)service, urCapInformation);
            contributions.add(urCapProgramNode);
        }
    }

    public static URCapInformation createURCapInformation(Bundle bundle) {
        Dictionary headers = null;
        if (bundle != null) {
            headers = bundle.getHeaders();
        }
        return new URCapInformation(ProgramURCapProvider.dictionary2map(headers));
    }

    private static Map<String, String> dictionary2map(Dictionary<String, String> dictionary) {
        if (dictionary == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result.put(key, dictionary.get(key));
        }
        return result;
    }
}

