/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi;

import com.ur.lang.StringUtils;
import com.ur.polyscope.urcaps.BundleUtils;
import com.ur.polyscope.urcaps.ExceptionHandling;
import com.ur.polyscope.urcaps.TextResource;
import com.ur.polyscope.urcaps.contributions.compatibility.CompatibilityError;
import com.ur.urcap.osgi.PackageInfo;
import com.ur.urcap.osgi.URCapErrorLogger;
import com.ur.urcap.osgi.bundle.BundleContextHelper;
import com.ur.urcap.osgi.bundle.BundleUtility;
import com.ur.urcap.osgi.bundle.PackageExportInfo;
import com.ur.urcap.osgi.error.URCapError;
import com.ur.urcap.osgi.error.URCapErrorBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

@Singleton
public class URCapFailureHandler {
    private static Set<URCapErrorLogger> loggers = new HashSet<URCapErrorLogger>();
    private static Provider<URCapErrorBuilder> errorBuilderProvider = null;
    private static TextResource textResource;
    private static ExceptionHandling exceptionHandling;
    private final BundleContext context;
    private static BundleUtils bundleUtils;

    public URCapFailureHandler(BundleContext context) {
        this.context = context;
    }

    @Inject
    public static void setLoggers(Set<URCapErrorLogger> loggers) {
        URCapFailureHandler.loggers.addAll(loggers);
    }

    @Inject
    public static void setBundleUtils(BundleUtils bundleUtils) {
        URCapFailureHandler.bundleUtils = bundleUtils;
    }

    public static void addLogger(URCapErrorLogger logger) {
        loggers.add(logger);
    }

    @Inject
    public static void setExceptionHandling(ExceptionHandling exceptionHandling) {
        URCapFailureHandler.exceptionHandling = exceptionHandling;
    }

    @Inject
    public static void setURCapErrorBuilder(Provider<URCapErrorBuilder> errorBuilderProvider) {
        URCapFailureHandler.errorBuilderProvider = errorBuilderProvider;
    }

    @Inject
    public static void setTextResource(TextResource textResource) {
        URCapFailureHandler.textResource = textResource;
    }

    public FailureType logFailure(Bundle bundle, Exception exception) {
        FailureType failureState = this.getFailureType(bundle, exception);
        this.logFailureState(bundle, exception, failureState);
        return failureState;
    }

    private FailureType getFailureType(Bundle bundle, Exception exception) {
        if (URCapFailureHandler.isUnresolved(bundle)) {
            return this.getSpecificUnresolvableType(exception);
        }
        if (URCapFailureHandler.isResolved(bundle)) {
            return this.getActivatorErrorType(bundle, exception);
        }
        return FailureType.UNKNOWN;
    }

    private FailureType getSpecificUnresolvableType(Exception e) {
        boolean apiRelated = this.getUnresolvedPackage(e).getPackage().startsWith("com.ur.urcap.api");
        return apiRelated ? FailureType.UNRESOLVABLE_URCAP_API : FailureType.UNRESOLVABLE_OTHER;
    }

    private FailureType getActivatorErrorType(Bundle bundle, Exception e) {
        String activator = (String)bundle.getHeaders().get("Bundle-Activator");
        if (this.hasActivatorInBundle(bundle, activator)) {
            if (e.getCause() instanceof Error) {
                return FailureType.ERROR_IN_ACTIVATOR_START;
            }
            return FailureType.EXCEPTION_IN_ACTIVATOR_START;
        }
        return FailureType.ACTIVATOR_NOT_FOUND;
    }

    public boolean hasActivatorInBundle(Bundle bundle, String activator) {
        return bundle.findEntries(this.getPathOfActivator(activator), this.getActivatorClass(activator), false) != null;
    }

    private String getPathOfActivator(String activator) {
        int lastIndexOf = activator.lastIndexOf(46);
        return "/" + activator.substring(0, lastIndexOf + 1).replace('.', '/');
    }

    private String getActivatorClass(String activator) {
        int lastIndexOf = activator.lastIndexOf(46);
        return String.valueOf(activator.substring(lastIndexOf + 1)) + ".class";
    }

    private PackageInfo getUnresolvedPackage(Exception e) {
        if (e.getMessage().contains("&(osgi.wiring.package=") && e.getMessage().contains("(version>=")) {
            return this.getUnresolvedPackageWithVersion(e);
        }
        return this.getUnresolvedPackageWithoutVersion(e);
    }

    private PackageInfo getUnresolvedPackageWithVersion(Exception e) {
        String message = e.getMessage();
        int startOfPackage = message.indexOf("&(osgi.wiring.package=");
        int endOfPackage = message.indexOf(41, startOfPackage);
        String packageVal = message.substring(startOfPackage + "&(osgi.wiring.package=".length(), endOfPackage);
        int startOfMinVersion = message.indexOf("(version>=", endOfPackage);
        int endOfMinVersion = message.indexOf(41, startOfMinVersion);
        String minVersion = message.substring(startOfMinVersion + "(version>=".length(), endOfMinVersion);
        int startOfMaxVersion = message.indexOf("(version>=", endOfMinVersion);
        int endOfMaxVersion = message.indexOf(41, startOfMaxVersion);
        String maxVersion = message.substring(startOfMaxVersion + "(version>=".length(), endOfMaxVersion);
        return new PackageInfo(packageVal, minVersion, maxVersion);
    }

    private PackageInfo getUnresolvedPackageWithoutVersion(Exception e) {
        String message = e.getMessage();
        int startOfPackage = message.indexOf("(osgi.wiring.package=");
        int endOfPackage = message.indexOf(41, startOfPackage);
        String packageVal = message.substring(startOfPackage + "(osgi.wiring.package=".length(), endOfPackage);
        return new PackageInfo(packageVal, "", "");
    }

    private void logFailureState(Bundle b, Exception e, FailureType failureState) {
        switch (failureState) {
            case UNRESOLVABLE_URCAP_API: {
                this.logUnresolvableURCapAPI(b);
                break;
            }
            case UNRESOLVABLE_OTHER: {
                this.logUnresolvableOther(b, e);
                break;
            }
            case EXCEPTION_IN_ACTIVATOR_START: {
                this.logExceptionInActivatorStart(b, e);
                break;
            }
            case ERROR_IN_ACTIVATOR_START: {
                this.logErrorInActivatorStart(b, e);
                break;
            }
            case ACTIVATOR_NOT_FOUND: {
                this.logActivatorNotFound(b);
                break;
            }
            case UNKNOWN: {
                this.logUnknown(b);
            }
        }
    }

    private void logActivatorNotFound(Bundle b) {
        String urCapName = bundleUtils.getUrcapName(b);
        URCapError error = this.defaultErrorBuilder(b).message("Could not find Activator at the path specified in 'Bundle-Activator' property in the pom.xml file.").localizedSubject(textResource.ErrorStartingURCap(urCapName)).localizedMessage(textResource.URCapActivatorNotFound("Bundle-Activator")).build();
        this.log(error);
    }

    private void logUnresolvableURCapAPI(Bundle b) {
        URCapErrorBuilder errorBuilder = this.defaultErrorBuilder(b);
        String urCapName = bundleUtils.getUrcapName(b);
        String message = "This URCap requires a newer URCap API version. Try to update to the newest Polyscope version.";
        URCapError error = errorBuilder.message(message).localizedSubject(textResource.ErrorStartingURCap(urCapName)).localizedMessage(textResource.URCapNeedsAPIPackage()).localizedSuggestion(textResource.TryToUpdate()).build();
        this.log(error);
    }

    private void logUnresolvableOther(Bundle b, Exception e) {
        URCapErrorBuilder errorBuilder = this.defaultErrorBuilder(b);
        String urCapName = bundleUtils.getUrcapName(b);
        String bundleName = this.getBundleName(b);
        PackageInfo unresolvedPackage = this.getUnresolvedPackage(e);
        String pkg = unresolvedPackage.getPackage();
        List<PackageExportInfo> packageExport = BundleContextHelper.findPackageExport(this.context, pkg);
        if (!packageExport.isEmpty()) {
            String fullMessage = "This URCap needs 3rd party dependency which is not available in the correct version. Polyscope bundle '%s' requires package '%s' %s. The only available version is %s.";
            String foundVersion = packageExport.get(0).getVersion();
            String message = String.format(fullMessage, bundleName, pkg, unresolvedPackage.getVersionText(), foundVersion);
            errorBuilder.message(message).localizedSubject(textResource.ErrorStartingURCap(urCapName)).localizedMessage(textResource.URCapNeeds3rdPartyPackageUnavailableInCorrectVersion()).localizedAdvancedMessage(this.getLocalizedVersionMessageVersionFound(foundVersion, unresolvedPackage, bundleName));
        } else {
            String message = String.format("This URCap needs 3rd party dependency which is not available. Polyscope bundle '%s' requires package '%s' which is not available.", bundleName, pkg);
            errorBuilder.message(message).localizedSubject(textResource.ErrorStartingURCap(urCapName)).localizedMessage(textResource.URCapNeedsUnavailable3rdPartyPackage()).localizedAdvancedMessage(textResource.URCapNeeds3rdPartyPackageNoVersion(unresolvedPackage.getPackage()));
        }
        URCapError error = errorBuilder.build();
        this.log(error);
    }

    private String getLocalizedVersionMessageVersionFound(String foundVersion, PackageInfo unresolvedPackage, String bundleName) {
        String pkg = unresolvedPackage.getPackage();
        String min = unresolvedPackage.getMinVersion();
        String max = unresolvedPackage.getMaxVersion();
        if (unresolvedPackage.isVersionRange()) {
            return textResource.BundleRequires3rdPartyPackageVersionRangeFoundInVersion(bundleName, pkg, min, max, foundVersion);
        }
        return textResource.BundleRequires3rdPartyPackageVersionNonRangeFoundInVersion(bundleName, pkg, min, foundVersion);
    }

    private void logExceptionInActivatorStart(Bundle b, Exception e) {
        String urCapName = bundleUtils.getUrcapName(b);
        String filteredStackTrace = this.getFilteredStackTrace(e);
        URCapError error = this.defaultErrorBuilder(b).message("URCap encountered an exception during startup.").localizedSubject(textResource.ErrorStartingURCap(urCapName)).localizedMessage(textResource.URCapEncounteredException()).localizedAdvancedMessage(filteredStackTrace).stackTrace(filteredStackTrace).build();
        this.log(error);
    }

    private String getFilteredStackTrace(Exception e) {
        Throwable throwable = e;
        if (e instanceof BundleException && ((BundleException)((Object)e)).getNestedException() != null) {
            throwable = ((BundleException)((Object)e)).getNestedException();
        }
        StackTraceElement exitPoint = this.getStackTraceElementJustOutsidePolyScope(throwable);
        return exceptionHandling.getStackTraceOutsidePolyScope(throwable, exitPoint);
    }

    private StackTraceElement getStackTraceElementJustOutsidePolyScope(Throwable throwable) {
        StackTraceElement exitPoint = null;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            if (stackTraceElement.getClassName().equalsIgnoreCase("org.apache.felix.framework.util.SecureAction") && stackTraceElement.getMethodName().equalsIgnoreCase("startActivator")) break;
            exitPoint = stackTraceElement;
            ++n2;
        }
        return exitPoint;
    }

    private void logErrorInActivatorStart(Bundle b, Exception e) {
        String urCapName = bundleUtils.getUrcapName(b);
        URCapError error = this.defaultErrorBuilder(b).message("URCap encountered an error during startup.").localizedSubject(textResource.ErrorStartingURCap(urCapName)).localizedMessage(textResource.URCapEncounteredError()).localizedAdvancedMessage(e.getCause().toString()).build();
        this.log(error);
    }

    private void logUnknown(Bundle b) {
        String urCapName = bundleUtils.getUrcapName(b);
        URCapError error = this.defaultErrorBuilder(b).message("Unknown reason.").localizedSubject(textResource.ErrorStartingURCap(urCapName)).localizedMessage(textResource.UnknownReason()).build();
        this.log(error);
    }

    private URCapErrorBuilder defaultErrorBuilder(Bundle bundle) {
        String urCapName = bundleUtils.getUrcapName(bundle);
        URCapErrorBuilder errorBuilder = ((URCapErrorBuilder)errorBuilderProvider.get()).bundle(bundle).subject(String.format("Error starting URCap '%s'", urCapName)).localizedTitle(textResource.CannotStartURCap(urCapName));
        if (BundleUtils.isZipInstalledBundle((Bundle)bundle)) {
            errorBuilder.dictionary(BundleUtility.URCapZipInfo2Dictionary(bundleUtils.getURCapZipInfo(bundle)));
        } else {
            errorBuilder.dictionary(bundle.getHeaders());
        }
        return errorBuilder;
    }

    private void log(URCapError error) {
        for (URCapErrorLogger logger : loggers) {
            logger.logError(error);
        }
    }

    public void logCompatibilityError(CompatibilityError error, Bundle bundle) {
        String urCapName = bundleUtils.getUrcapName(bundle);
        URCapError urCapError = this.defaultErrorBuilder(bundle).message(error.getMessage()).localizedSubject(textResource.ErrorStartingURCap(urCapName)).localizedMessage(error.getLocalizedMessage()).localizedSuggestion(error.getLocalizedSuggestion()).build();
        this.log(urCapError);
    }

    private String getBundleName(Bundle bundle) {
        String name = (String)bundle.getHeaders().get("Bundle-Name");
        return !StringUtils.isNullOrEmpty((String)name) ? name : bundle.getSymbolicName();
    }

    private static boolean isUnresolved(Bundle b) {
        return b.getState() == 2;
    }

    private static boolean isResolved(Bundle b) {
        return b.getState() == 4;
    }

    public static enum FailureType {
        UNRESOLVABLE_URCAP_API,
        UNRESOLVABLE_OTHER,
        EXCEPTION_IN_ACTIVATOR_START,
        ERROR_IN_ACTIVATOR_START,
        ACTIVATOR_NOT_FOUND,
        UNKNOWN;

    }
}

