/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi;

import com.ur.polyscope.urcaps.TextResource;
import com.ur.polyscope.urcaps.URCapZipInfo;
import com.ur.polyscope.urcaps.URServiceClient;
import com.ur.urcap.osgi.URCapErrorLogger;
import com.ur.urcap.osgi.bundle.BundleFileInfo;
import com.ur.urcap.osgi.bundle.BundleUtility;
import com.ur.urcap.osgi.error.URCapError;
import com.ur.urcap.osgi.error.URCapErrorBuilder;
import com.ur.util.logging.Log;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

@Singleton
public class URCapInvalidHandler {
    private static Set<URCapErrorLogger> loggers = new HashSet<URCapErrorLogger>();
    private static Provider<URCapErrorBuilder> errorBuilderProvider = null;
    private static TextResource textResource;
    private static URServiceClient urServiceClient;
    private static final String ERROR_START_TITLE = "Error starting URCap '%s'";
    private URCapZipInfo urCapZipInfo = new URCapZipInfo();
    private String urcapName = "";
    private String polyscopeBundle = "";
    private final BundleContext context;

    public URCapInvalidHandler(BundleContext context) {
        this.context = context;
    }

    @Inject
    public static void setLoggers(Set<URCapErrorLogger> loggers) {
        URCapInvalidHandler.loggers.addAll(loggers);
    }

    public static void addLogger(URCapErrorLogger logger) {
        loggers.add(logger);
    }

    @Inject
    public static void setURCapErrorBuilder(Provider<URCapErrorBuilder> errorBuilderProvider) {
        URCapInvalidHandler.errorBuilderProvider = errorBuilderProvider;
    }

    @Inject
    public static void setTextResource(TextResource textResource) {
        URCapInvalidHandler.textResource = textResource;
    }

    @Inject
    public static void setURServiceClient(URServiceClient urServiceClient) {
        URCapInvalidHandler.urServiceClient = urServiceClient;
    }

    public void logInvalidURCap(File file) {
        Bundle duplicateBundle;
        boolean isZipBasedURCap = this.isZipBasedURCap(file);
        this.populateBundleAndURCapName(file, isZipBasedURCap);
        URCapErrorBuilder errorBuilder = (URCapErrorBuilder)errorBuilderProvider.get();
        if (!BundleUtility.hasManifestFile(file)) {
            this.logErrorForMissingManifest(errorBuilder, file);
            return;
        }
        if (!BundleUtility.isThirdPartyURCap(file)) {
            if (isZipBasedURCap) {
                errorBuilder.dictionary(BundleUtility.URCapZipInfo2Dictionary(this.urCapZipInfo));
            } else {
                errorBuilder.dictionary(BundleUtility.properties2Dictionary(BundleUtility.getManifestProperties(file)));
            }
            this.logErrorForInvalidBundleCategory(errorBuilder, file);
            return;
        }
        if (!isZipBasedURCap) {
            this.urcapName = this.getURCapName(file);
        }
        if ((duplicateBundle = this.getActiveBundleWithDuplicateSymbolicNameAndVersion(file)) != null) {
            String fileName = (String)duplicateBundle.getHeaders().get("Bundle-Name");
            String displayName = String.valueOf(this.urcapName) + " [" + this.polyscopeBundle + "]";
            errorBuilder.subject(String.format("Error starting URCap '%s' [%s]", this.urcapName, this.polyscopeBundle)).message(String.format("The already running Polyscope bundle '%s' has same symbolic name and version.", fileName)).localizedSubject(textResource.ErrorStartingURCapFile(this.urcapName, this.polyscopeBundle)).localizedMessage(textResource.AlreadyRunning(fileName)).localizedTitle(textResource.CannotStartURCap(displayName)).bundle(new BundleFileInfo(file, true));
        } else {
            errorBuilder.subject(String.format(ERROR_START_TITLE, this.urcapName)).message("This URCap has an invalid manifest file ('META-INF/MANIFEST.MF').").localizedSubject(textResource.ErrorStartingURCap(this.urcapName)).localizedMessage(textResource.InvalidManifestFile()).localizedTitle(textResource.CannotStartURCap(this.urcapName)).bundle(new BundleFileInfo(file));
        }
        this.log(errorBuilder.build());
    }

    private void populateBundleAndURCapName(File file, boolean isZipBasedURCap) {
        if (isZipBasedURCap) {
            this.populateURCapZipInfo(file);
            this.urcapName = this.urCapZipInfo.getName();
            this.polyscopeBundle = this.getPolyscopeBundle(file);
        } else {
            this.urcapName = file.getName();
            this.polyscopeBundle = file.getName();
        }
    }

    private void populateURCapZipInfo(File file) {
        String resourceId = "";
        String artifactType = "polyscope-bundle";
        try {
            resourceId = file.getCanonicalPath();
            this.urCapZipInfo = urServiceClient.getURCapIdentificationFromArtifact(artifactType, resourceId);
        }
        catch (Exception e) {
            Log.error((String)String.format("Could not look up URCap identification based on artifactType: %s and artifactId: %s", artifactType, resourceId), (Throwable)e);
        }
    }

    private String getPolyscopeBundle(File file) {
        String artifactId = "";
        String resourceId = "";
        String artifactType = "polyscope-bundle";
        try {
            resourceId = file.getCanonicalPath();
            artifactId = urServiceClient.getArtifactId(artifactType, resourceId);
        }
        catch (Exception e) {
            Log.error((String)String.format("Could not look up artifact ID based on artifactType: %s and resourceId: %s", artifactType, resourceId), (Throwable)e);
        }
        return artifactId;
    }

    private boolean isZipBasedURCap(File file) {
        return "zip".equalsIgnoreCase(file.getParentFile().getName());
    }

    private void logErrorForMissingManifest(URCapErrorBuilder errorBuilder, File file) {
        errorBuilder.subject(String.format(ERROR_START_TITLE, this.urcapName)).message(String.format("PolyScope bundle '%s' is not a valid. The manifest file ('META-INF/MANIFEST.MF') is missing.", this.polyscopeBundle)).localizedSubject(textResource.ErrorStartingURCap(this.urcapName)).localizedMessage(textResource.IsNotValidURCapFile(this.polyscopeBundle)).localizedAdvancedMessage(textResource.MissingManifestFile()).localizedTitle(textResource.CannotStartURCap(this.urcapName)).bundle(new BundleFileInfo(file));
        this.log(errorBuilder.build());
    }

    private void logErrorForInvalidBundleCategory(URCapErrorBuilder errorBuilder, File file) {
        errorBuilder.subject(String.format(ERROR_START_TITLE, this.urcapName)).message(String.format("PolyScope bundle '%s' is not valid. The 'Bundle-Category' attribute in the manifest file ('META-INF/MANIFEST.MF') must be present and have the value 'URCap'.", this.polyscopeBundle)).localizedSubject(textResource.ErrorStartingURCap(this.urcapName)).localizedMessage(textResource.IsNotValidURCapFile(this.polyscopeBundle)).localizedAdvancedMessage(textResource.InvalidOrMissingBundleCategory()).localizedTitle(textResource.CannotStartURCap(this.urcapName)).bundle(new BundleFileInfo(file));
        this.log(errorBuilder.build());
    }

    private Bundle getActiveBundleWithDuplicateSymbolicNameAndVersion(File file) {
        Properties properties = BundleUtility.getManifestProperties(file);
        if (properties == null) {
            return null;
        }
        String symbolicName = (String)properties.get("Bundle-SymbolicName");
        String version = (String)properties.get("Bundle-Version");
        Bundle[] bundleArray = this.context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (this.isSameSymbolicName(symbolicName, bundle) && this.isSameVersion(version, bundle) && !BundleUtility.isSameFile(file, bundle)) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    private boolean isSameSymbolicName(String symbolicName, Bundle bundle) {
        return bundle.getSymbolicName().equalsIgnoreCase(symbolicName);
    }

    private boolean isSameVersion(String version, Bundle bundle) {
        return bundle.getVersion().compareTo(new Version(version)) == 0;
    }

    private void log(URCapError error) {
        for (URCapErrorLogger logger : loggers) {
            logger.logError(error);
        }
    }

    private String getURCapName(File file) {
        Properties properties = BundleUtility.getManifestProperties(file);
        String name = null;
        if (properties != null && (name = (String)properties.get("Bundle-Name")) == null) {
            name = (String)properties.get("Bundle-SymbolicName");
        }
        return name != null ? name : file.getName();
    }
}

