/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi;

import com.ur.monitor.RobotState;
import com.ur.urcap.api.domain.URCapAPI;
import com.ur.urcap.api.domain.URCapAPIFacade;
import com.ur.urcap.api.domain.program.nodes.ProgramNodeFactory;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.RobotMode;
import gui.main.OnStartup;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class WarmUpURCapAPI
implements OnStartup {
    public void run() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean controllerReady = WarmUpURCapAPI.this.waitForController();
                boolean apiReady = WarmUpURCapAPI.this.waitForAPI();
                if (controllerReady && apiReady) {
                    WarmUpURCapAPI.this.warmUpAPI();
                }
            }
        }).start();
    }

    private void warmUpAPI() {
        URCapAPI urCapAPI = URCapAPIFacade.getURCapAPI();
        ProgramNodeFactory programNodeFactory = urCapAPI.getProgramAPIProvider().getProgramAPI().getProgramModel().getProgramNodeFactory();
        Method[] methodArray = ProgramNodeFactory.class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (this.isMethodWithoutArgumentsAndAnnotations(method)) {
                this.invokeCreateMethod(programNodeFactory, method);
            }
            ++n2;
        }
    }

    private void invokeCreateMethod(ProgramNodeFactory programNodeFactory, Method method) {
        try {
            method.invoke((Object)programNodeFactory, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException e) {
            Log.error((String)("Failed to warmup API: " + method.toGenericString()), (Throwable)e);
        }
    }

    private boolean waitForAPI() {
        return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return URCapAPIFacade.getURCapAPI() != null;
            }
        }, (int)2, (TimeUnit)TimeUnit.MINUTES);
    }

    private boolean waitForController() {
        return Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return RobotState.getLatestRobotState().robotMode != RobotMode.NO_CONTROLLER;
            }
        }, (int)2, (TimeUnit)TimeUnit.MINUTES);
    }

    private boolean isMethodWithoutArgumentsAndAnnotations(Method method) {
        String name = method.getName();
        return name.startsWith("create") && method.getParameterTypes().length == 0 && method.getAnnotations().length == 0;
    }
}

