/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.bundle;

import com.ur.urcap.osgi.bundle.PackageExportInfo;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class BundleContextHelper {
    private BundleContextHelper() {
    }

    public static List<PackageExportInfo> findPackageExport(BundleContext bundleContext, String packageName) {
        Bundle[] bundles;
        ArrayList<PackageExportInfo> infoList = new ArrayList<PackageExportInfo>();
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            Dictionary headers = bundle.getHeaders();
            String exportString = (String)headers.get("Export-Package");
            if (exportString != null) {
                List<PackageExportInfo> packages = BundleContextHelper.findPackageExport(exportString);
                for (PackageExportInfo info : packages) {
                    info.setBundle(bundle);
                    infoList.add(info);
                }
            }
            ++n2;
        }
        return BundleContextHelper.findExactMatch(infoList, packageName);
    }

    public static List<PackageExportInfo> findExactMatch(Iterable<PackageExportInfo> candidates, String packageName) {
        ArrayList<PackageExportInfo> infoList = new ArrayList<PackageExportInfo>();
        for (PackageExportInfo info : candidates) {
            if (!info.getPackageName().equals(packageName)) continue;
            infoList.add(info);
        }
        return infoList;
    }

    public static List<PackageExportInfo> findPackageExport(String exportString) {
        String[] splited;
        ArrayList<PackageExportInfo> infoList = new ArrayList<PackageExportInfo>();
        String[] stringArray = splited = exportString.split(",");
        int n = splited.length;
        int n2 = 0;
        while (n2 < n) {
            String exportLine = stringArray[n2];
            String[] exportLineSplit = exportLine.split(";");
            if (exportLineSplit.length > 1) {
                String exportPackageName = exportLineSplit[0];
                String version = BundleContextHelper.extractVersion(exportLineSplit);
                if (!version.isEmpty()) {
                    PackageExportInfo info = new PackageExportInfo();
                    info.setPackageName(exportPackageName);
                    info.setVersion(version);
                    infoList.add(info);
                }
            }
            ++n2;
        }
        return infoList;
    }

    private static String extractVersion(String[] exportLineSplit) {
        String version = "";
        int j = 1;
        while (j < exportLineSplit.length) {
            if (exportLineSplit[j].startsWith("version=\"")) {
                version = exportLineSplit[j].substring("version=\"".length(), exportLineSplit[j].length() - 1);
                break;
            }
            ++j;
        }
        return version;
    }
}

