/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.bundle;

import com.ur.urcap.osgi.bundle.BundleUtility;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;

public class BundleFileInfo {
    private final File file;
    private boolean isSameSymbolicNameVersion;

    public BundleFileInfo(File file) {
        this.file = file;
    }

    public BundleFileInfo(File file, boolean isSameSymbolicNameVersion) {
        this.file = file;
        this.isSameSymbolicNameVersion = isSameSymbolicNameVersion;
    }

    public Dictionary<String, String> getHeaders() {
        return BundleUtility.properties2Dictionary(BundleUtility.getManifestProperties(this.file));
    }

    public String getFileName() {
        return this.file.getName();
    }

    public boolean isSameSymbolicNameVersion() {
        return this.isSameSymbolicNameVersion;
    }

    public String getFileLocation() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException e) {
            Log.error((String)"Cannot find canonical path of file", (Throwable)e);
            return "";
        }
    }
}

