/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.bundle;

import com.ur.polyscope.urcaps.URCapZipInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;

public class BundleUtility {
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    public static final String BUNDLE_CATEGORY = "Bundle-Category";

    public static boolean isThirdPartyURCap(File file) {
        Properties properties = BundleUtility.getManifestProperties(file);
        String bundleCategory = null;
        if (properties != null) {
            bundleCategory = (String)properties.get(BUNDLE_CATEGORY);
        }
        return bundleCategory != null && bundleCategory.equalsIgnoreCase("urcap");
    }

    private static Properties getProperties(InputStream inputStream) {
        Properties properties = new Properties();
        Scanner scan = new Scanner(inputStream);
        String key = "";
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.contains(": ")) {
                String[] lineSplit = line.split(":");
                key = lineSplit[0];
                String value = lineSplit[1].substring(1);
                properties.put(key, value);
            }
            if (!line.startsWith(" ") || properties.getProperty(key) == null) continue;
            properties.put(key, properties.getProperty(key).concat(line.substring(1)));
        }
        return properties;
    }

    /*
     * Loose catch block
     */
    public static Properties getManifestProperties(File file) {
        Properties properties;
        ZipFile zf;
        block11: {
            zf = null;
            zf = new ZipFile(file);
            ZipEntry e = zf.getEntry(MANIFEST_FILE);
            properties = BundleUtility.getProperties(zf.getInputStream(e));
            if (zf == null) break block11;
            try {
                zf.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
        catch (Exception exception) {
            block12: {
                try {
                    if (zf == null) break block12;
                }
                catch (Throwable throwable) {
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean hasManifestFile(File file) {
        boolean bl;
        ZipFile zf;
        block11: {
            zf = null;
            zf = new ZipFile(file);
            boolean bl2 = bl = zf.getEntry(MANIFEST_FILE) != null;
            if (zf == null) break block11;
            try {
                zf.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
        catch (Exception exception) {
            block12: {
                try {
                    if (zf == null) break block12;
                }
                catch (Throwable throwable) {
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
            return false;
        }
    }

    /*
     * Loose catch block
     */
    public ZipEntry getManifestFile(File file) {
        ZipEntry zipEntry;
        ZipFile zf;
        block11: {
            zf = null;
            zf = new ZipFile(file);
            zipEntry = zf.getEntry(MANIFEST_FILE);
            if (zf == null) break block11;
            try {
                zf.close();
            }
            catch (IOException iOException) {}
        }
        return zipEntry;
        catch (Exception exception) {
            block12: {
                try {
                    if (zf == null) break block12;
                }
                catch (Throwable throwable) {
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    public static Dictionary<String, String> properties2Dictionary(Properties properties) {
        if (properties == null) {
            return new Hashtable<String, String>();
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            ((Dictionary)result).put(key, properties.getProperty(key));
        }
        return result;
    }

    public static Dictionary<String, String> URCapZipInfo2Dictionary(URCapZipInfo urCapZipInfo) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        ((Dictionary)result).put("Bundle-Name", urCapZipInfo.getName());
        ((Dictionary)result).put("Bundle-Version", urCapZipInfo.getVersion());
        ((Dictionary)result).put("Bundle-Vendor", urCapZipInfo.getVendorName());
        ((Dictionary)result).put("Bundle-ContactAddress", urCapZipInfo.getContactInfo());
        ((Dictionary)result).put("Bundle-Description", urCapZipInfo.getDescription());
        ((Dictionary)result).put("Bundle-Copyright", urCapZipInfo.getCopyRight());
        ((Dictionary)result).put("Bundle-LicenseType", urCapZipInfo.getLicenseType());
        return result;
    }

    /*
     * Loose catch block
     */
    public static boolean isSameFile(File file, Bundle bundle) {
        boolean bl;
        ZipFile zf;
        block11: {
            zf = null;
            zf = new ZipFile(file);
            ZipEntry e = zf.getEntry(MANIFEST_FILE);
            bl = IOUtils.contentEquals((InputStream)zf.getInputStream(e), (InputStream)bundle.getResource(MANIFEST_FILE).openStream());
            if (zf == null) break block11;
            try {
                zf.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
        catch (Exception exception) {
            block12: {
                try {
                    if (zf == null) break block12;
                }
                catch (Throwable throwable) {
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
            return false;
        }
    }
}

