/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.error;

import com.ur.lang.StringUtils;
import com.ur.log.logentry.LogEntryExplanationRenderer;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.urcaps.TextResource;
import com.ur.urcap.html.util.HTMLBuilder;
import com.ur.urcap.osgi.bundle.BundleFileInfo;
import com.ur.urcap.osgi.error.URCapError;
import com.ur.util.swing.HTML;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.errorcodes.MessageSource;
import com.ur.view.constants.errorcodes.ReportLevel;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.osgi.framework.Bundle;

public class URCapErrorBuilder {
    private final TextResource textResource;
    private final com.ur.i18n.TextResource internalTextResource;
    private String subject = "";
    private String message = "";
    private String localizedSubject = "";
    private String localizedMessage = "";
    private String localizedSuggestion = "";
    private String localizedAdvancedMessage = "";
    private String localizedTitle = "";
    private Dictionary<String, String> urcapInformation;
    private Bundle bundle;
    private BundleFileInfo bundleFileInfo;
    private String stackTrace;
    private static String margin = "p style=\"padding-top:8px;\"";

    @Inject
    public URCapErrorBuilder(TextResource textResource, com.ur.i18n.TextResource internalTextResource) {
        this.textResource = textResource;
        this.internalTextResource = internalTextResource;
        this.urcapInformation = new Hashtable<String, String>();
    }

    public URCapErrorBuilder bundle(Bundle bundle) {
        this.bundle = bundle;
        return this;
    }

    public URCapErrorBuilder bundle(BundleFileInfo bundleFileInfo) {
        this.bundleFileInfo = bundleFileInfo;
        return this;
    }

    public URCapErrorBuilder subject(String subject) {
        this.subject = subject;
        return this;
    }

    public URCapErrorBuilder localizedTitle(String title) {
        this.localizedTitle = title;
        return this;
    }

    public URCapErrorBuilder message(String message) {
        this.message = message;
        return this;
    }

    public URCapErrorBuilder localizedSubject(String localizedHeader) {
        this.localizedSubject = localizedHeader;
        return this;
    }

    public URCapErrorBuilder localizedMessage(String localizedMessage) {
        this.localizedMessage = localizedMessage;
        return this;
    }

    public URCapErrorBuilder localizedSuggestion(String localizedSuggestion) {
        this.localizedSuggestion = localizedSuggestion;
        return this;
    }

    public URCapErrorBuilder dictionary(Dictionary<String, String> urcapInformation) {
        this.urcapInformation = urcapInformation;
        return this;
    }

    public URCapErrorBuilder localizedAdvancedMessage(String localizedAdvancedMessage) {
        this.localizedAdvancedMessage = localizedAdvancedMessage;
        return this;
    }

    public URCapErrorBuilder stackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }

    public URCapError build() {
        RobotMessage robotMessage = this.buildError();
        URCapError error = new URCapError();
        error.setBundle(this.bundle);
        error.setBundleFileInfo(this.bundleFileInfo);
        error.setUrcapInfo(this.urcapInformation);
        error.setMessage(this.message);
        error.setRobotMessage(robotMessage);
        if (this.localizedTitle.isEmpty()) {
            error.setLocalizedTitle(this.localizedSubject);
        } else {
            error.setLocalizedTitle(this.localizedTitle);
        }
        error.setLocalizedMessage(this.localizedMessage);
        error.setLocalizedSuggestion(this.localizedSuggestion);
        error.setFullMessage(this.buildMessageText(this.subject, this.message));
        error.setLocalizedAdvancedMessage(this.localizedAdvancedMessage);
        error.setStackTrace(this.stackTrace);
        return error;
    }

    private RobotMessage buildError() {
        RobotMessage robotMessage = new RobotMessage();
        robotMessage.message = this.localizedSubject;
        this.setupExplanationRendering(this.buildExplanation(), robotMessage);
        robotMessage.warningLevel = ReportLevel.WARNING;
        robotMessage.timestamp = System.currentTimeMillis();
        robotMessage.type = RobotMessageType.TEXT;
        robotMessage.source = MessageSource.GUI;
        return robotMessage;
    }

    private String buildExplanation() {
        HTMLBuilder html = new HTMLBuilder();
        html.start("div style=\"width:270px;\"");
        html.start("p");
        html.text(this.localizedMessage);
        html.br();
        this.addSuggestionIfPresent(html);
        this.addAdvancedDetailsIfPresent(html);
        html.end("p");
        this.addURCapInfoIfPresent(html);
        html.end("div");
        return html.toString();
    }

    private void addSuggestionIfPresent(HTMLBuilder html) {
        if (!StringUtils.isNullOrEmpty((String)this.localizedSuggestion)) {
            html.start("p");
            html.br();
            html.b(this.internalTextResource.Suggestion());
            html.br();
            html.end("p");
            html.start(margin);
            html.text(this.localizedSuggestion);
            html.end("p");
        }
    }

    private void addAdvancedDetailsIfPresent(HTMLBuilder html) {
        if (!StringUtils.isNullOrEmpty((String)this.localizedAdvancedMessage)) {
            html.start("p");
            html.br();
            html.b(this.internalTextResource.AdvancedDetails());
            html.br();
            html.end("p");
            html.start(margin);
            html.appendHtml(this.localizedAdvancedMessage);
            html.end("p");
        }
    }

    private void addURCapInfoIfPresent(HTMLBuilder html) {
        if (this.urcapInformation != null && !this.urcapInformation.isEmpty()) {
            html.br();
            html.appendHtml("<hr>");
            html.br();
            html.appendHtml(this.createURCapInfoHTMLTable());
        }
    }

    private String createURCapInfoHTMLTable() {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
        if (this.urcapInformation.get("Bundle-Name") != null) {
            details.put(this.textResource.urcapName(), this.urcapInformation.get("Bundle-Name"));
        }
        if (this.urcapInformation.get("Bundle-Version") != null) {
            details.put(this.textResource.urcapVersion(), this.urcapInformation.get("Bundle-Version"));
        }
        if (this.urcapInformation.get("Bundle-Vendor") != null) {
            details.put(this.textResource.Developer(), this.urcapInformation.get("Bundle-Vendor"));
        }
        if (this.urcapInformation.get("Bundle-ContactAddress") != null) {
            details.put(this.textResource.urcapContactinfo(), this.urcapInformation.get("Bundle-ContactAddress"));
        }
        StringBuilder rows = new StringBuilder();
        for (Map.Entry label : details.entrySet()) {
            rows.append(this.createHTMLTableRow(label.getKey(), label.getValue()));
        }
        return HTML.tableWithProperties((String)"", (String[])new String[]{rows.toString()});
    }

    private String createHTMLTableRow(Object label, Object value) {
        return HTML.tableRow((String[])new String[]{HTML.tableCellAlignTop((String)(String.valueOf(label.toString()) + ":")), HTML.tableCellAlignTop((String)HTML.fontBold((String)value.toString()))});
    }

    private void setupExplanationRendering(final String explanation, RobotMessage robotMessage) {
        robotMessage.extraData = new LogEntryExplanationRenderer(){

            public String getExplanation() {
                return explanation;
            }
        };
    }

    private String buildMessageText(String subject, String message) {
        StringBuilder fullMessage = new StringBuilder();
        if (!StringUtils.isNullOrEmpty((String)subject)) {
            fullMessage.append(subject);
        }
        if (!StringUtils.isNullOrEmpty((String)message)) {
            if (!StringUtils.isNullOrEmpty((String)fullMessage.toString())) {
                fullMessage.append(": ");
            }
            fullMessage.append(message);
        }
        return fullMessage.toString();
    }
}

