/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.resources.ViewImageResource;
import com.ur.urcap.osgi.error.URCapError;
import com.ur.urcap.osgi.infrastructure.BundleWrapper;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ActiveBundleCellRenderer
extends JLabel
implements ListCellRenderer {
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        BundleWrapper bundleWrapper = (BundleWrapper)value;
        this.setText(bundleWrapper.getDisplayName());
        this.setIcon(this.getIcon(bundleWrapper));
        this.setOpaque(true);
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        return this;
    }

    Icon getIcon(BundleWrapper bundleWrapper) {
        if (bundleWrapper.requiresRestart()) {
            return ViewImageResource.urcapSetupScreenRestart();
        }
        if (bundleWrapper.isActive()) {
            return this.isStartedCorrect(bundleWrapper) ? ViewImageResource.urcapSetupScreenOk() : ViewImageResource.urcapSetupScreenError();
        }
        return ViewImageResource.urcapSetupScreenOkInactive();
    }

    private boolean isStartedCorrect(BundleWrapper bundleWrapper) {
        URCapError error = bundleWrapper.getBundleError();
        if (error != null) {
            return false;
        }
        if (bundleWrapper.getType() == BundleWrapper.Type.ZIP) {
            return true;
        }
        if (bundleWrapper.getBundle() != null) {
            return bundleWrapper.getBundle().getState() == 32;
        }
        return false;
    }
}

