/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.polyscope.urcaps.URCapZipInfo;
import com.ur.urcap.osgi.bundle.BundleFileInfo;
import com.ur.urcap.osgi.error.URCapError;
import java.util.Dictionary;
import org.osgi.framework.Bundle;

public class BundleWrapper {
    private URCapZipInfo zipBasedInfo;
    private Bundle bundle;
    private BundleFileInfo bundleFileInfo;
    private final boolean requiresRestart;
    private final boolean isActive;
    private final boolean requiresLicense;
    private String displayName;
    private boolean isRemovable;
    private URCapError bundleError;
    private final Type type;

    BundleWrapper(Bundle bundle, boolean requiresRestart, boolean isActive, boolean addVersionToDisplayName, boolean isRemovable, boolean requiresLicense) {
        this.bundle = bundle;
        this.requiresLicense = requiresLicense;
        this.requiresRestart = requiresRestart;
        this.isActive = isActive;
        this.isRemovable = isRemovable;
        this.type = Type.BUNDLE;
        this.resolveName(bundle, addVersionToDisplayName);
    }

    BundleWrapper(BundleFileInfo bundleFileInfo, boolean requiresRestart, boolean isActive, boolean isRemovable, boolean requiresLicense) {
        this.requiresLicense = requiresLicense;
        this.requiresRestart = requiresRestart;
        this.isActive = isActive;
        this.isRemovable = isRemovable;
        this.bundleFileInfo = bundleFileInfo;
        this.type = Type.FILE;
        this.resolveName(bundleFileInfo);
    }

    public BundleWrapper(URCapZipInfo zipBasedInfo, boolean requiresRestart) {
        this.zipBasedInfo = zipBasedInfo;
        this.displayName = zipBasedInfo.getName();
        this.requiresLicense = false;
        this.requiresRestart = requiresRestart;
        this.isActive = true;
        this.isRemovable = true;
        this.type = Type.ZIP;
    }

    public URCapZipInfo getZipBasedInfo() {
        return this.zipBasedInfo;
    }

    public Type getType() {
        return this.type;
    }

    private void resolveName(Bundle bundle, boolean addVersionToDisplayName) {
        Dictionary headers = bundle.getHeaders();
        this.displayName = (String)headers.get("Bundle-Name");
        if (this.displayName == null) {
            this.displayName = bundle.getSymbolicName();
        }
        if (addVersionToDisplayName) {
            this.displayName = String.valueOf(this.displayName) + " (" + bundle.getVersion() + ")";
        }
    }

    private void resolveName(BundleFileInfo bundleFileInfo) {
        Dictionary<String, String> headers = bundleFileInfo.getHeaders();
        if (!headers.isEmpty()) {
            this.displayName = headers.get("Bundle-Name");
            if (bundleFileInfo.isSameSymbolicNameVersion()) {
                this.displayName = String.valueOf(this.displayName) + " [" + bundleFileInfo.getFileName() + "]";
            }
        } else {
            this.displayName = "[" + bundleFileInfo.getFileName() + "]";
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public BundleFileInfo getBundleFileInfo() {
        return this.bundleFileInfo;
    }

    public boolean requiresRestart() {
        return this.requiresRestart;
    }

    public boolean requiresLicense() {
        return this.requiresLicense;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isRemovable() {
        return this.isRemovable;
    }

    public URCapError getBundleError() {
        return this.bundleError;
    }

    public void setBundleError(URCapError bundleError) {
        this.bundleError = bundleError;
    }

    static enum Type {
        BUNDLE,
        FILE,
        ZIP;

    }
}

