/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.resources.ViewImageResource;
import com.ur.swing.extensible.AddToView;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.urcap.osgi.infrastructure.ManageURCapsViewImpl;
import java.awt.Color;
import java.awt.Component;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

@Singleton
@ExtensionPoint(value="URCapSettingsFooter")
public class G5ButtonPanel
implements AddToView {
    JPanel buttons = new JPanel();
    JPanel extensions = new JPanel();
    ManageURCapsViewImpl manageURCapsViewImpl;

    public G5ButtonPanel() {
        this.extensions.setVisible(true);
    }

    public void initComponents(ManageURCapsViewImpl manageURCapsViewImpl) {
        this.buttons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttons.setLayout(new BoxLayout(this.buttons, 2));
        this.buttons.add(manageURCapsViewImpl.getAddUrcapButton());
        this.buttons.add(Box.createHorizontalStrut(5));
        this.buttons.add(manageURCapsViewImpl.getRemoveUrcapButton());
        this.buttons.add(Box.createHorizontalGlue());
        this.buttons.add(this.extensions);
        this.buttons.add(Box.createHorizontalStrut(5));
        this.buttons.add(manageURCapsViewImpl.getRestartButton());
        this.extensions.setBorder(BorderFactory.createEmptyBorder());
        this.extensions.setLayout(new BoxLayout(this.extensions, 2));
        this.manageURCapsViewImpl = manageURCapsViewImpl;
    }

    public void addComponent(JComponent jComponent) {
        jComponent.setAlignmentX(1.0f);
        this.extensions.add(jComponent);
        if (jComponent instanceof JButton) {
            ((JButton)jComponent).addActionListener(e -> SwingUtilities.invokeLater(() -> this.manageURCapsViewImpl.populateUrCapLists()));
            ((JButton)jComponent).setIcon(ViewImageResource.blank1x24());
        }
    }

    public JPanel getButtons() {
        return this.buttons;
    }

    public void toggleExtensionVisibility(boolean visible) {
        this.extensions.setVisible(visible);
    }

    public void setEnablementOnExtension(boolean enabled) {
        Component[] componentArray = this.extensions.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JButton) {
                this.setEnablementOnButton((JButton)component, enabled);
            }
            ++n2;
        }
    }

    private void setEnablementOnButton(JButton jButton, boolean enabled) {
        if (enabled) {
            this.enablePrimaryButton(jButton);
        } else {
            this.disableButton(jButton);
        }
    }

    private void enablePrimaryButton(JButton button) {
        button.setForeground(Color.BLACK);
        button.setBackground(G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE);
        button.setEnabled(true);
    }

    private void disableButton(JButton button) {
        button.setForeground(Color.BLACK);
        button.setBackground(Color.WHITE);
        button.setEnabled(false);
    }
}

