/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.resources.ViewImageResource;
import com.ur.urcap.osgi.infrastructure.BundleWrapper;
import com.ur.urcap.osgi.infrastructure.ThirdPartyLicenseManager;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

final class InactiveBundleCellRenderer
extends JLabel
implements ListCellRenderer {
    private final ThirdPartyLicenseManager licenseManager;

    public InactiveBundleCellRenderer(ThirdPartyLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        BundleWrapper bundleWrapper = (BundleWrapper)value;
        this.setText(bundleWrapper.getDisplayName());
        this.setIcon(this.getIcon(bundleWrapper));
        this.setOpaque(true);
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        return this;
    }

    private Icon getIcon(BundleWrapper bundleWrapper) {
        if (bundleWrapper.requiresRestart() || bundleWrapper.requiresLicense() && this.licenseManager.isLicenseUpdated()) {
            return ViewImageResource.urcapSetupScreenRestart();
        }
        return bundleWrapper.requiresLicense() ? ViewImageResource.inactiveUrCap() : ViewImageResource.urcapSetupScreenOkInactive();
    }
}

