/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.i18n.TextResource;
import com.ur.urcap.osgi.infrastructure.ThirdPartyBundleManager;
import com.ur.urcap.osgi.infrastructure.URCapTaskCallbacks;
import com.ur.urcap.osgi.infrastructure.URCapsServiceImpl;
import com.ur.util.concurrent.SequentialTask;
import java.io.File;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class InstallBundleURCapTask
extends SequentialTask {
    private final URCapTaskCallbacks taskHandlerFactory;
    private final File destinationFile;
    private Bundle bundle;
    private BundleContext bundleContext;
    private String bundleURI;
    private URCapsServiceImpl.BundleBasedURCapCallback installCallback;
    private File urCapFile;
    private ThirdPartyBundleManager thirdPartyBundleManager;

    public InstallBundleURCapTask(File urcapFile, File destinationFile, BundleContext bundleContext, ThirdPartyBundleManager thirdPartyBundleManager, URCapTaskCallbacks taskHandlerFactory, TextResource textResource, URCapsServiceImpl.BundleBasedURCapCallback installCallback) {
        super(textResource.installingURCap(urcapFile.getName()));
        this.bundleContext = bundleContext;
        this.bundleURI = "reference:file:" + destinationFile.getPath();
        this.destinationFile = destinationFile;
        this.urCapFile = urcapFile;
        this.thirdPartyBundleManager = thirdPartyBundleManager;
        this.taskHandlerFactory = taskHandlerFactory;
        this.installCallback = installCallback;
    }

    public void run() {
        try {
            this.bundle = this.thirdPartyBundleManager.install(this.bundleContext, this.bundleURI);
        }
        catch (BundleException e) {
            this.taskHandlerFactory.onErrorInstallBundleBasedURCap(this.urCapFile, this.destinationFile, (Exception)((Object)e));
        }
    }

    public void onAfter() {
        this.taskHandlerFactory.onAfterInstallBundleBasedURCap(this.bundle, this.installCallback);
    }

    public void onError(Throwable throwable) {
        this.taskHandlerFactory.onErrorInstallBundleBasedURCap(this.urCapFile, this.destinationFile, new Exception(throwable));
    }
}

