/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.disk.Directories;
import com.ur.i18n.TextResource;
import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.lang.persist.WriteableModuleSettings;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.filemanager.URFileFilter;
import com.ur.polyscope.license.LicenseUpdatedListener;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLock;
import com.ur.polyscope.security.adminrootpasswordlinker.domain.AdminLockListener;
import com.ur.polyscope.security.adminrootpasswordlinker.view.RequireAdminPasswordFooter;
import com.ur.polyscope.system.ShutdownService;
import com.ur.polyscope.urcaps.BundleUtils;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.URFingerDragScrollMouseListener;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.urcap.osgi.infrastructure.ActiveBundleCellRenderer;
import com.ur.urcap.osgi.infrastructure.BundleWrapper;
import com.ur.urcap.osgi.infrastructure.G5ButtonPanel;
import com.ur.urcap.osgi.infrastructure.G5RegisterPanel;
import com.ur.urcap.osgi.infrastructure.InactiveBundleCellRenderer;
import com.ur.urcap.osgi.infrastructure.ManageURCapsView;
import com.ur.urcap.osgi.infrastructure.RestartAction;
import com.ur.urcap.osgi.infrastructure.ThirdPartyBundleManager;
import com.ur.urcap.osgi.infrastructure.ThirdPartyLicenseManager;
import com.ur.urcap.osgi.infrastructure.URCapFileFilter;
import com.ur.urcap.osgi.infrastructure.URCapsMetaInfoBuilder;
import com.ur.urcap.osgi.infrastructure.URCapsService;
import com.ur.urcap.osgi.infrastructure.URCapsServiceImpl;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

@Singleton
public class ManageURCapsViewImpl
extends ManageURCapsView
implements AdminLockListener {
    private static final String NORMAL_CARD = "NORMAL";
    private static final String LICENSE_CARD = "LICENSE";
    private static final String OLDER_VERSION_CARD = "OLDER_VERSION_CARD";
    static final String SYSTEM_ADMIN_PASSWORD = "systemPassword";
    private static final Log log = LogFactory.getLog(ManageURCapsViewImpl.class);
    private final transient FilePersistence filePersistence;
    private final transient ShutdownService shutdownService;
    private static final WriteableModuleSettings SAFETY_SETTINGS = new WriteableModuleSettings("safety.properties");
    private transient BundleListener bundleListener;
    private final transient URCapsService urCapsService;
    private boolean enableRestartButton;
    private File currentSelection;
    private transient FileContainer urCapFileContainer;
    private DefaultListModel activeUrCapListModel;
    private final transient WidgetFactory widgetFactory;
    private final transient TextResource textResource;
    private final transient BundleUtils bundleUtils;
    private final EventManager eventManager;
    private final transient G5ButtonPanel buttonPanel;
    private final transient G5RegisterPanel registerPanel;
    private final ThirdPartyBundleManager thirdPartyBundleManager;
    private final ThirdPartyLicenseManager licenseManager;
    private final URCapsMetaInfoBuilder metaInfoBuilder;
    private final RequireAdminPasswordFooter passwordFooter;
    private final AdminLock adminLock;
    private JEditorPane metaInfo;
    private JEditorPane inactiveMetaInfo;
    private JEditorPane olderVersionMetaInfo;
    private JScrollPane metaInfoScrollPane;
    private JScrollPane inactiveMetaInfoScrollPane;
    private JScrollPane olderVersionMetaInfoScrollPane;
    private JPanel lowerPanel;
    private JButton addUrcapButton;
    private JButton removeUrcapButton;
    private JButton restartButton;
    private JList urCapList;
    private JList inactiveUrCapList;
    private DefaultListModel inactiveUrCapListModel;
    private Subscription licenseUpdateListener;
    private RestartAction restartAction;
    private boolean lockStateTriggeredUpdate;
    private final transient ListSelectionListener activeListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ManageURCapsViewImpl.this.inactiveUrCapList.clearSelection();
            ManageURCapsViewImpl.this.update();
        }
    };
    private final transient ListSelectionListener inactiveListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ManageURCapsViewImpl.this.urCapList.clearSelection();
            ManageURCapsViewImpl.this.update();
        }
    };
    private boolean isLocked;

    @Inject
    public ManageURCapsViewImpl(URCapsService urCapsService, FilePersistence filePersistence, ViewContext viewContext, BundleUtils bundleUtils, ShutdownService shutdownService, G5ButtonPanel buttonPanel, G5RegisterPanel registerPanel, ThirdPartyBundleManager thirdPartyBundleManager, ThirdPartyLicenseManager licenseManager, EventManager eventManager, URCapsMetaInfoBuilder metaInfoBuilder, RequireAdminPasswordFooter passwordFooter, AdminLock adminLock) {
        this.filePersistence = filePersistence;
        this.shutdownService = shutdownService;
        this.buttonPanel = buttonPanel;
        this.registerPanel = registerPanel;
        this.thirdPartyBundleManager = thirdPartyBundleManager;
        this.licenseManager = licenseManager;
        this.metaInfoBuilder = metaInfoBuilder;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.urCapsService = urCapsService;
        this.widgetFactory = viewContext.createWidgetFactory();
        this.bundleUtils = bundleUtils;
        this.eventManager = eventManager;
        this.passwordFooter = passwordFooter;
        this.adminLock = adminLock;
        this.buildComponents();
        this.update();
        this.setCallbackForURCapBundleEvents(urCapsService);
        if (FeatureToggle.isActive((String)SYSTEM_ADMIN_PASSWORD)) {
            adminLock.addListener((AdminLockListener)this);
        }
    }

    private void setCallbackForURCapBundleEvents(URCapsService urCapsService) {
        urCapsService.setCallbackForBundleEvents(new URCapsServiceImpl.BundleBasedURCapCallback(){

            @Override
            void onNewURCapInstalled() {
                SwingUtilities.invokeLater(() -> {
                    ManageURCapsViewImpl.this.populateUrCapLists();
                    ManageURCapsViewImpl.this.update();
                });
            }
        });
    }

    @Override
    public void setContext(BundleContext context) {
    }

    private void buildComponents() {
        GridLayout urcapListLayout = new GridLayout(1, 2, 5, 0);
        JPanel urcapCard = new JPanel(urcapListLayout);
        urcapCard.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        urcapCard.add(this.createCard(this.textResource.activeURCaps(), this.createActiveList()));
        urcapCard.add(this.createCard(this.textResource.inactiveURCaps(), this.createInactiveList()));
        JPanel activeLowerPanel = this.createActiveLowerPanel();
        JPanel licenseLowerPanel = this.createLicenseLowerPanel();
        JPanel olderVersionPanel = this.createOlderVersionLowerPanel();
        this.addToLowerPanel(activeLowerPanel, licenseLowerPanel, olderVersionPanel);
        this.createButtons();
        this.buttonPanel.initComponents(this);
        JPanel centerGroupPanel = new JPanel(new BorderLayout(5, 5));
        centerGroupPanel.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        centerGroupPanel.add((Component)urcapCard, "North");
        centerGroupPanel.add((Component)this.lowerPanel, "Center");
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)centerGroupPanel, "Center");
        contentPanel.add((Component)this.buttonPanel.getButtons(), "South");
        this.setLayout(new BorderLayout());
        this.add(contentPanel, "Center");
        this.addPasswordFooter();
    }

    private void addPasswordFooter() {
        JPanel footerJPanel = this.passwordFooter.getFooterPanel();
        this.add(this.createCard(null, footerJPanel), "South");
        if (!FeatureToggle.isActive((String)SYSTEM_ADMIN_PASSWORD)) {
            footerJPanel.setVisible(false);
        }
    }

    private void addToLowerPanel(JPanel activeLowerPanel, JPanel licensePanel, JPanel olderVersionPanel) {
        this.lowerPanel = new JPanel(new CardLayout());
        this.lowerPanel.setBorder((Border)new CardBorder(this.textResource.urcapInformation()));
        this.lowerPanel.add((Component)activeLowerPanel, NORMAL_CARD);
        this.lowerPanel.add((Component)licensePanel, LICENSE_CARD);
        this.lowerPanel.add((Component)olderVersionPanel, OLDER_VERSION_CARD);
    }

    private JPanel createOlderVersionLowerPanel() {
        this.olderVersionMetaInfo = new JEditorPane("text/html", "");
        this.olderVersionMetaInfoScrollPane = this.createMetaInfoScrollPane(this.olderVersionMetaInfo);
        JEditorPane olderVersionDescription = new JEditorPane("text/html", "");
        olderVersionDescription.setText("<p>" + this.textResource.URCapOlderVersionDescriptionPart1() + "</p><br>" + "<p>" + this.textResource.URCapOlderVersionDescriptionPart2() + "</p>");
        JScrollPane olderVersionDescriptionScrollPane = this.createMetaInfoScrollPane(olderVersionDescription);
        JPanel olderVersionPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        olderVersionPanel.add(this.olderVersionMetaInfoScrollPane);
        olderVersionPanel.add(olderVersionDescriptionScrollPane);
        return olderVersionPanel;
    }

    private JPanel createLicenseLowerPanel() {
        this.inactiveMetaInfo = new JEditorPane("text/html", "");
        this.inactiveMetaInfoScrollPane = this.createMetaInfoScrollPane(this.inactiveMetaInfo);
        JPanel licensePanel = new JPanel(new GridLayout(1, 2, 5, 0));
        licensePanel.add(this.inactiveMetaInfoScrollPane);
        licensePanel.add(this.registerPanel.getRegisterScrollPane());
        return licensePanel;
    }

    private JPanel createActiveLowerPanel() {
        this.metaInfo = new JEditorPane("text/html", "");
        this.metaInfoScrollPane = this.createMetaInfoScrollPane(this.metaInfo);
        JPanel metaInfoPanel = new JPanel(new BorderLayout());
        metaInfoPanel.add((Component)this.metaInfoScrollPane, "Center");
        return metaInfoPanel;
    }

    private void createButtons() {
        this.restartAction = new RestartAction(this.shutdownService, this.textResource, ViewImageResource.blank1x24(), this.urCapsService);
        this.restartButton = this.widgetFactory.createButton((Action)((Object)this.restartAction));
        this.updateEnableStateOnRestartButton();
        this.addUrcapButton = this.widgetFactory.createButton((Action)((Object)new AddUrCapAction()));
        this.removeUrcapButton = this.widgetFactory.createButton((Action)((Object)new RemoveUrCapAction()));
    }

    private JScrollPane createMetaInfoScrollPane(JEditorPane metaInfo) {
        metaInfo.setEditable(false);
        new URFingerDragScrollMouseListener((Component)metaInfo);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(metaInfo);
        return scrollPane;
    }

    private JScrollPane createInactiveList() {
        this.inactiveUrCapList = this.widgetFactory.createList();
        this.inactiveUrCapList.setName("inactiveURCapList");
        this.inactiveUrCapList.setCellRenderer(new InactiveBundleCellRenderer(this.licenseManager));
        this.inactiveUrCapList.getSelectionModel().setSelectionMode(0);
        this.inactiveUrCapList.addListSelectionListener(this.inactiveListListener);
        JScrollPane inactiveUrCapListScrollPane = new JScrollPane();
        inactiveUrCapListScrollPane.setViewportView(this.inactiveUrCapList);
        return inactiveUrCapListScrollPane;
    }

    private JScrollPane createActiveList() {
        this.urCapList = this.widgetFactory.createList();
        this.urCapList.setCellRenderer(new ActiveBundleCellRenderer());
        this.urCapList.getSelectionModel().setSelectionMode(0);
        this.urCapList.addListSelectionListener(this.activeListListener);
        JScrollPane urCapListScrollPane = new JScrollPane();
        urCapListScrollPane.setViewportView(this.urCapList);
        return urCapListScrollPane;
    }

    @Override
    public void dispose() {
        this.urCapList.removeListSelectionListener(this.activeListListener);
        this.inactiveUrCapList.removeListSelectionListener(this.inactiveListListener);
    }

    @Override
    public void enter(Object o) {
        this.addListener();
        if (this.urCapFileContainer != null && this.urCapFileContainer.getFile() != null) {
            this.currentSelection = this.urCapFileContainer.getFile();
            this.urCapsService.installURCap(this.currentSelection);
            this.urCapFileContainer = null;
        }
        this.populateUrCapLists();
        CardLayout cl = (CardLayout)this.lowerPanel.getLayout();
        cl.show(this.lowerPanel, NORMAL_CARD);
        this.metaInfo.setText("");
        if (this.buttonPanel != null) {
            this.buttonPanel.toggleExtensionVisibility(false);
        }
        this.setLicenseUpdateListener();
    }

    private void setLicenseUpdateListener() {
        this.licenseUpdateListener = this.eventManager.addStrongListener(LicenseUpdatedListener.class, () -> {
            if (this.licenseManager.isLicenseUpdated()) {
                SwingUtilities.invokeLater(() -> {
                    this.enableRestartButton = true;
                    this.updateEnableStateOnRestartButton();
                });
            }
        });
    }

    private void addListener() {
        this.bundleListener = event -> SwingUtilities.invokeLater(() -> {
            this.populateUrCapLists();
            if (event.getBundle().getState() != 1) {
                this.selectNewlyInstalledURCap(event);
            }
            this.update();
        });
        this.urCapsService.addBundleListener(this.bundleListener);
        this.restartAction.setBundleListener(this.bundleListener);
    }

    private void selectNewlyInstalledURCap(BundleEvent event) {
        Enumeration activeURCaps = this.activeUrCapListModel.elements();
        while (activeURCaps.hasMoreElements()) {
            Object urCap = activeURCaps.nextElement();
            if (!(urCap instanceof BundleWrapper) || ((BundleWrapper)urCap).getBundle() == null || !((BundleWrapper)urCap).getBundle().equals(event.getBundle())) continue;
            this.urCapList.setSelectedValue(urCap, true);
            break;
        }
    }

    public Object exit() {
        this.removeListener();
        this.licenseUpdateListener.dispose();
        this.cleanup();
        return super.exit();
    }

    private void cleanup() {
        this.passwordFooter.resetPasswordField();
    }

    private void removeListener() {
        if (this.bundleListener != null) {
            this.urCapsService.removeBundleListener(this.bundleListener);
            this.bundleListener = null;
        }
    }

    void populateUrCapLists() {
        this.activeUrCapListModel = new DefaultListModel();
        this.inactiveUrCapListModel = new DefaultListModel();
        for (BundleWrapper bundleWrapper : this.thirdPartyBundleManager.getThirdPartyBundles()) {
            ManageURCapsViewImpl.setSafetyAPIFlag(bundleWrapper);
            if (bundleWrapper.isActive()) {
                if (!this.isBundleDeleted(bundleWrapper)) {
                    this.activeUrCapListModel.addElement(bundleWrapper);
                } else {
                    this.enableRestartButton = true;
                }
            } else {
                this.inactiveUrCapListModel.addElement(bundleWrapper);
            }
            this.enableRestartButton = this.enableRestartButton || bundleWrapper.requiresLicense() && this.licenseManager.isLicenseUpdated();
            boolean bl = this.enableRestartButton = this.enableRestartButton || bundleWrapper.requiresRestart();
        }
        this.urCapList.setModel(this.activeUrCapListModel);
        this.inactiveUrCapList.setModel(this.inactiveUrCapListModel);
        this.updateEnableStateOnRestartButton();
    }

    private static void setSafetyAPIFlag(BundleWrapper bundleWrapper) {
        if (!SAFETY_SETTINGS.properties().getBoolean("dynamicSafetyEnabled", false) && ManageURCapsViewImpl.isSickSafetyURCap(bundleWrapper)) {
            try {
                SAFETY_SETTINGS.properties().setProperty("dynamicSafetyEnabled", "true");
                SAFETY_SETTINGS.write();
            }
            catch (IOException e) {
                log.warn((Object)"Failed to write dynamic API flag", (Throwable)e);
            }
        }
    }

    private static boolean isSickSafetyURCap(BundleWrapper bundleWrapper) {
        Bundle bundle = bundleWrapper.getBundle();
        return bundle.getSymbolicName().toLowerCase(Locale.ROOT).contains("sick") && ((String)bundle.getHeaders().get("Import-Package")).contains("com.ur.urcap.api.domain.device.safety");
    }

    private boolean isBundleDeleted(BundleWrapper bundleWrapper) {
        if (bundleWrapper.getType() == BundleWrapper.Type.ZIP) {
            return false;
        }
        if (bundleWrapper.getBundle() != null && bundleWrapper.getBundle().getState() == 1) {
            return true;
        }
        if (bundleWrapper.getBundle() == null) {
            File file = new File(bundleWrapper.getBundleFileInfo().getFileLocation());
            return !file.exists();
        }
        return false;
    }

    private void update() {
        Object activeSelection = this.urCapList.getSelectedValue();
        Object inActiveSelection = this.inactiveUrCapList.getSelectedValue();
        if (activeSelection instanceof BundleWrapper) {
            this.updateActiveLowerPanel((BundleWrapper)activeSelection);
        } else if (inActiveSelection instanceof BundleWrapper) {
            this.updateInactiveLowerPanel((BundleWrapper)inActiveSelection);
        } else {
            this.clearLowerPanel();
        }
        if (this.licenseManager.isLicenseUpdated() && !this.enableRestartButton) {
            this.enableRestartButton = true;
            this.updateEnableStateOnRestartButton();
        }
    }

    private void clearLowerPanel() {
        CardLayout cl = (CardLayout)this.lowerPanel.getLayout();
        cl.show(this.lowerPanel, NORMAL_CARD);
        this.removeUrcapButton.setEnabled(false);
        if (this.buttonPanel != null) {
            this.buttonPanel.toggleExtensionVisibility(false);
        }
        this.metaInfo.setText("");
    }

    private void updateInactiveLowerPanel(BundleWrapper inActiveSelection) {
        CardLayout cl = (CardLayout)this.lowerPanel.getLayout();
        this.removeUrcapButton.setEnabled(inActiveSelection.isRemovable() && !this.isLocked);
        if (inActiveSelection.requiresLicense()) {
            cl.show(this.lowerPanel, LICENSE_CARD);
            this.setMetaInfo(inActiveSelection, this.inactiveMetaInfo, this.inactiveMetaInfoScrollPane);
        } else {
            cl.show(this.lowerPanel, OLDER_VERSION_CARD);
            this.setMetaInfo(inActiveSelection, this.olderVersionMetaInfo, this.olderVersionMetaInfoScrollPane);
        }
    }

    private void updateActiveLowerPanel(BundleWrapper activeSelection) {
        CardLayout cl = (CardLayout)this.lowerPanel.getLayout();
        cl.show(this.lowerPanel, NORMAL_CARD);
        this.removeUrcapButton.setEnabled(activeSelection.isRemovable() && !this.isLocked);
        this.setMetaInfo(activeSelection, this.metaInfo, this.metaInfoScrollPane);
    }

    private void setMetaInfo(BundleWrapper bundleWrapper, JEditorPane metaInfo, JScrollPane metaInfoScrollPane) {
        String urcapMetaInfo = this.metaInfoBuilder.getMetaInfo(this.bundleUtils, bundleWrapper);
        metaInfo.setText(urcapMetaInfo);
        metaInfo.setCaretPosition(0);
        metaInfoScrollPane.setViewportView(metaInfo);
        this.showLicenseExtension(bundleWrapper);
    }

    private void showLicenseExtension(BundleWrapper bundleWrapper) {
        if (this.buttonPanel == null) {
            return;
        }
        if (!this.adminLock.isLocked()) {
            this.buttonPanel.setEnablementOnExtension(bundleWrapper.requiresLicense());
        }
        this.buttonPanel.toggleExtensionVisibility(bundleWrapper.requiresLicense());
    }

    private synchronized void updateEnableStateOnRestartButton() {
        this.restartButton.setEnabled(this.enableRestartButton);
        if (this.enableRestartButton) {
            DisplayMessageFactory.inform((JComponent)this.restartButton, (String)this.textResource.urcapRestartrequired());
        }
    }

    private JPanel createCard(String cardTitle, JComponent panel) {
        JPanel result = new JPanel(new BorderLayout());
        if (cardTitle != null) {
            result.setBorder((Border)new CardBorder(cardTitle));
        }
        result.add((Component)panel, "Center");
        return result;
    }

    JButton getAddUrcapButton() {
        return this.addUrcapButton;
    }

    JButton getRemoveUrcapButton() {
        return this.removeUrcapButton;
    }

    JButton getRestartButton() {
        return this.restartButton;
    }

    public void doUnlock() {
        this.addUrcapButton.setEnabled(true);
        this.isLocked = false;
        if (this.lockStateTriggeredUpdate) {
            this.lockStateTriggeredUpdate = false;
            return;
        }
        this.lockStateTriggeredUpdate = true;
        this.update();
    }

    public void doLock() {
        this.isLocked = true;
        this.addUrcapButton.setEnabled(false);
        this.removeUrcapButton.setEnabled(false);
        this.buttonPanel.setEnablementOnExtension(false);
    }

    private BundleWrapper getSelection() {
        if (this.urCapList.getSelectedValue() instanceof BundleWrapper) {
            return (BundleWrapper)this.urCapList.getSelectedValue();
        }
        if (this.inactiveUrCapList.getSelectedValue() instanceof BundleWrapper) {
            return (BundleWrapper)this.inactiveUrCapList.getSelectedValue();
        }
        return null;
    }

    private class AddUrCapAction
    extends AbstractActionDefinition {
        AddUrCapAction() {
            this.putValue("SmallIcon", ViewImageResource.gtkAdd());
            this.putValue("InternalName", "AddUrCap");
        }

        public void actionPerformed(ActionEvent e) {
            ManageURCapsViewImpl.this.urCapFileContainer = new FileContainer();
            ManageURCapsViewImpl.this.urCapFileContainer.setFile(ManageURCapsViewImpl.this.currentSelection);
            ManageURCapsViewImpl.this.filePersistence.openSettingsFile(ManageURCapsViewImpl.this.urCapFileContainer, new FileManagerConfiguration(ManageURCapsViewImpl.this.textResource.urcapSelectfile(), FileManagerConfiguration.Access.UNRESTRICTED, Directories.programs(), new URFileFilter[]{new URCapFileFilter()}));
        }
    }

    private class RemoveUrCapAction
    extends AbstractActionDefinition {
        RemoveUrCapAction() {
            this.putValue("SmallIcon", ViewImageResource.gtkRemove());
            this.putValue("InternalName", "RemoveUrCap");
        }

        public void actionPerformed(ActionEvent e) {
            BundleWrapper selection = ManageURCapsViewImpl.this.getSelection();
            if (selection != null) {
                if (selection.getBundle() != null) {
                    ManageURCapsViewImpl.this.urCapsService.uninstallURCap(selection.getBundle());
                    this.enableRestart();
                } else if (selection.getBundleFileInfo() != null && !selection.getBundleFileInfo().isSameSymbolicNameVersion()) {
                    ManageURCapsViewImpl.this.urCapsService.uninstallURCapFile(selection.getBundleFileInfo());
                    this.enableRestart();
                }
                ManageURCapsViewImpl.this.activeUrCapListModel.removeElement(selection);
                ManageURCapsViewImpl.this.inactiveUrCapListModel.removeElement(selection);
            }
        }

        private void enableRestart() {
            ManageURCapsViewImpl.this.enableRestartButton = true;
            ManageURCapsViewImpl.this.updateEnableStateOnRestartButton();
        }
    }
}

