/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.i18n.TextResource;
import com.ur.polyscope.system.ShutdownService;
import com.ur.swing.AbstractActionDefinition;
import com.ur.urcap.osgi.infrastructure.URCapsService;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.osgi.framework.BundleListener;

public class RestartAction
extends AbstractActionDefinition {
    private final transient ShutdownService shutdownService;
    private final URCapsService urCapsService;
    private BundleListener bundleListener;

    RestartAction(ShutdownService shutdownService, TextResource textResource, Icon icon, URCapsService urCapsService) {
        this.shutdownService = shutdownService;
        this.urCapsService = urCapsService;
        this.putValue("SmallIcon", icon);
        this.putValue("Name", textResource.restartNow());
        this.putValue("InternalName", "Restart");
    }

    public void actionPerformed(ActionEvent e) {
        if (this.bundleListener != null) {
            this.urCapsService.removeBundleListener(this.bundleListener);
        }
        this.shutdownService.requestGracefulRestartGUI();
    }

    public void setBundleListener(BundleListener bundleListener) {
        this.bundleListener = bundleListener;
    }
}

