/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.polyscope.urcaps.BundleUtils;
import com.ur.polyscope.urcaps.URCapZipInfo;
import com.ur.polyscope.urcaps.URServiceClient;
import com.ur.urcap.osgi.bundle.BundleFileInfo;
import com.ur.urcap.osgi.error.URCapError;
import com.ur.urcap.osgi.infrastructure.BundleWrapper;
import com.ur.urcap.osgi.infrastructure.ThirdPartyLicenseManager;
import com.ur.urcap.osgi.infrastructure.UnremovableBundleManager;
import com.ur.util.logging.Log;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

@Singleton
public class ThirdPartyBundleManager {
    private long timeStamp;
    private final UnremovableBundleManager unremovableBundleManager;
    private final ThirdPartyLicenseManager licenseManager;
    private Set<Bundle> allInstalledBundles;
    private Set<Bundle> activeBundles;
    private Set<Bundle> inactiveBundles;
    private Map<Bundle, URCapError> notCompatibleBundles;
    private Map<BundleFileInfo, URCapError> bundlesNotStarted;
    private static URServiceClient urServiceClient;
    private HashSet<BundleWrapper> bundleWrappers = new LinkedHashSet<BundleWrapper>();
    private static final String ZIPPATH = ".urcaps/zip/";

    @Inject
    public ThirdPartyBundleManager(ThirdPartyLicenseManager licenseManager, UnremovableBundleManager unremovableBundleManager) {
        this.unremovableBundleManager = unremovableBundleManager;
        this.licenseManager = licenseManager;
    }

    @Inject
    public static void setURServiceClient(URServiceClient urServiceClient) {
        ThirdPartyBundleManager.urServiceClient = urServiceClient;
    }

    public void setBundles(List<Bundle> thirdPartyBundles, List<Bundle> bundlesToStart, Map<Bundle, URCapError> notCompatibleBundles, Map<BundleFileInfo, URCapError> bundlesNotStarted) {
        this.allInstalledBundles = new LinkedHashSet<Bundle>(thirdPartyBundles);
        this.activeBundles = new LinkedHashSet<Bundle>(bundlesToStart);
        this.inactiveBundles = new LinkedHashSet<Bundle>(thirdPartyBundles);
        this.inactiveBundles.removeAll(this.activeBundles);
        Set<Bundle> notCompatible = notCompatibleBundles.keySet();
        this.inactiveBundles.removeAll(notCompatible);
        this.activeBundles.removeAll(notCompatible);
        this.notCompatibleBundles = notCompatibleBundles;
        this.bundlesNotStarted = bundlesNotStarted;
        this.timeStamp = System.currentTimeMillis();
        this.processBundles();
    }

    private void processBundles() {
        boolean requiresRestart;
        LinkedHashSet<BundleWrapper> result = new LinkedHashSet<BundleWrapper>();
        for (Bundle b : this.activeBundles) {
            if (this.isZipBased(b)) continue;
            requiresRestart = b.getLastModified() > this.timeStamp;
            result.add(new BundleWrapper(b, requiresRestart, true, this.moreThanOneVersionInstalled(b), this.isRemovable(b), this.licenseManager.requiresLicense(b)));
        }
        for (Bundle b : this.inactiveBundles) {
            requiresRestart = b.getLastModified() > this.timeStamp;
            result.add(new BundleWrapper(b, requiresRestart, false, this.moreThanOneVersionInstalled(b), this.isRemovable(b), this.licenseManager.requiresLicense(b)));
        }
        this.processNotCompatibleBundles(result);
        this.processNotStartedBundles(result);
        this.bundleWrappers = result;
    }

    private boolean isZipBased(Bundle b) {
        return b.getLocation().contains(ZIPPATH);
    }

    private void processNotStartedBundles(HashSet<BundleWrapper> result) {
        for (Map.Entry<BundleFileInfo, URCapError> entry : this.bundlesNotStarted.entrySet()) {
            BundleWrapper wrapper;
            BundleFileInfo bundleFileInfo = entry.getKey();
            if (bundleFileInfo.getFileLocation().contains(ZIPPATH)) {
                String polyscopeBundlePath = bundleFileInfo.getFileLocation();
                wrapper = this.processZipBundle(result, polyscopeBundlePath);
            } else {
                wrapper = new BundleWrapper(bundleFileInfo, false, true, true, false);
            }
            URCapError error = entry.getValue();
            if (wrapper == null) continue;
            wrapper.setBundleError(error);
            result.add(wrapper);
        }
    }

    private BundleWrapper processZipBundle(HashSet<BundleWrapper> result, String polyscopeBundlePath) {
        BundleWrapper wrapper = null;
        try {
            URCapZipInfo urCapZipInfo = urServiceClient.getURCapIdentificationFromArtifact("polyscope-bundle", polyscopeBundlePath);
            wrapper = new BundleWrapper(urCapZipInfo, false);
            this.removeZipBundle(result, urCapZipInfo);
        }
        catch (Exception e) {
            Log.error((String)String.format("Could not look up URCap identification based on artifactType: %s and artifactId: %s", "polyscope-bundle", polyscopeBundlePath), (Throwable)e);
        }
        return wrapper;
    }

    private void removeZipBundle(HashSet<BundleWrapper> result, URCapZipInfo urCapZipInfo) {
        result.removeIf(bundleWrapper -> bundleWrapper.getZipBasedInfo() != null && bundleWrapper.getZipBasedInfo().equals((Object)urCapZipInfo));
    }

    private void processNotCompatibleBundles(HashSet<BundleWrapper> result) {
        for (Map.Entry<Bundle, URCapError> entry : this.notCompatibleBundles.entrySet()) {
            BundleWrapper wrapper;
            Bundle bundle = entry.getKey();
            if (BundleUtils.isZipInstalledBundle((Bundle)bundle)) {
                String polyscopeBundlePath = this.getBundleLocation(bundle);
                wrapper = this.processZipBundle(result, polyscopeBundlePath);
            } else {
                wrapper = new BundleWrapper(bundle, false, true, false, true, this.licenseManager.requiresLicense(bundle));
            }
            URCapError error = entry.getValue();
            if (wrapper == null) continue;
            wrapper.setBundleError(error);
            result.add(wrapper);
        }
    }

    private boolean isRemovable(Bundle b) {
        return this.unremovableBundleManager.canRemove(b.getSymbolicName());
    }

    public boolean moreThanOneVersionInstalled(Bundle b) {
        for (Bundle bundle : this.allInstalledBundles) {
            if (!this.sameSymbolicNameDifferentVersion(bundle, b)) continue;
            return true;
        }
        return false;
    }

    private boolean sameSymbolicNameDifferentVersion(Bundle bundle, Bundle b) {
        return bundle.getSymbolicName().equals(b.getSymbolicName()) && bundle.getVersion().compareTo(b.getVersion()) != 0;
    }

    public synchronized Set<BundleWrapper> getThirdPartyBundles() {
        return this.bundleWrappers;
    }

    public synchronized void uninstall(Bundle bundle) {
        this.allInstalledBundles.remove(bundle);
        this.activeBundles.remove(bundle);
        this.inactiveBundles.remove(bundle);
        this.notCompatibleBundles.remove(bundle);
        this.processBundles();
    }

    public synchronized void uninstall(BundleFileInfo bundleFileInfo) {
        this.bundlesNotStarted.remove(bundleFileInfo);
        this.processBundles();
    }

    public synchronized Bundle install(BundleContext bundleContext, String bundleURI) throws BundleException {
        return bundleContext.installBundle(bundleURI);
    }

    public void processBundle(Bundle bundle) {
        this.allInstalledBundles.add(bundle);
        this.activeBundles.add(bundle);
        this.processBundles();
    }

    private String getBundleLocation(Bundle bundle) {
        String location = bundle.getLocation();
        location = this.removeFirst(location, "reference:");
        location = this.removeFirst(location, "file:");
        return location;
    }

    private String removeFirst(String location, String remove) {
        if (location.startsWith(remove)) {
            Log.info((String)("Removing '" + remove + "' from bundle location : " + location));
            return location.replaceFirst(remove, "");
        }
        return location;
    }
}

