/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.disk.Directories;
import java.io.File;
import javax.inject.Singleton;
import org.osgi.framework.Bundle;

@Singleton
public class ThirdPartyLicenseManager {
    private static final File LICENSE_FILE = new File(Directories.home(), ".polyscope/license.p7b");
    private long licenseTimestamp = this.getLicenseFileTimestamp();

    public long getLicenseFileTimestamp() {
        if (LICENSE_FILE.exists()) {
            return LICENSE_FILE.lastModified();
        }
        return 0L;
    }

    public boolean isLicenseUpdated() {
        return this.licenseTimestamp != this.getLicenseFileTimestamp();
    }

    public boolean requiresLicense(Bundle bundle) {
        return Boolean.TRUE.toString().equalsIgnoreCase((String)bundle.getHeaders().get("Bundle-RequireLicense"));
    }
}

