/*
 * Decompiled with CFR 0.152.
 */
package com.ur.urcap.osgi.infrastructure;

import com.ur.i18n.TextResource;
import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.filemanager.URFileFilter;
import com.ur.util.persist.FileUtils;
import gui.tools.LanguagePack;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class URCapFileFilter
extends URFileFilter {
    private static final String URCAP = "urcap";
    private static final String URCAPX = "urcapx";
    private static final String DOCKER_BASED_URCAPS = "docker-based-urcaps";
    private static final Set<String> EXTENSIONS = new HashSet<String>();
    private TextResource textResource;

    public URCapFileFilter() {
        EXTENSIONS.add(URCAP);
        EXTENSIONS.add(URCAPX);
        this.textResource = LanguagePack.getTextResource();
    }

    public boolean accept(File f) {
        return super.accept(f) || this.extensionIsAcceptable(f);
    }

    private boolean extensionIsAcceptable(File f) {
        String extension = FileUtils.getExtension((File)f);
        if (FeatureToggle.isActive((String)DOCKER_BASED_URCAPS)) {
            return extension != null && EXTENSIONS.contains(extension.toLowerCase());
        }
        return extension != null && URCAP.equalsIgnoreCase(extension);
    }

    public String getDescription() {
        return this.textResource.urcapFiles();
    }

    public String getFileExtension() {
        return URCAP;
    }
}

